"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewCardView = void 0;
var _eui = require("@elastic/eui");
var _reactWindowInfiniteLoader = _interopRequireDefault(require("react-window-infinite-loader"));
var _reactWindow = require("react-window");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _cards_view_footer = require("./cards_view_footer");
var _use_overview_status = require("../../../hooks/use_overview_status");
var _metric_item = require("../metric_item/metric_item");
var _overview_loader = require("../overview_loader");
var _grid_items_by_group = require("../grid_by_group/grid_items_by_group");
var _state = require("../../../../../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/overview_cards_view/overview_card_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ITEM_HEIGHT = _metric_item.METRIC_ITEM_HEIGHT + 12;
const MAX_LIST_HEIGHT = 800;
const MIN_BATCH_SIZE = 20;
const LIST_THRESHOLD = 12;
const MIN_CARD_WIDTH = 400;
const OverviewCardView = ({
  monitorsSortedByStatus,
  maxItem,
  setMaxItem,
  setFlyoutConfigCallback
}) => {
  const {
    groupBy: {
      field: groupField
    }
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const isUnGrouped = groupField === 'none';
  const trendData = (0, _reactRedux.useSelector)(_state.selectOverviewTrends);
  const {
    view
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const [rowCount, setRowCount] = (0, _react.useState)(5);
  const [currentIndex, setCurrentIndex] = (0, _react.useState)(0);
  const {
    loaded
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  const listHeight = Math.min(ITEM_HEIGHT * Math.ceil(monitorsSortedByStatus.length / rowCount), MAX_LIST_HEIGHT);
  const listItems = (0, _react.useMemo)(() => {
    const acc = [];
    for (let i = 0; i < monitorsSortedByStatus.length; i += rowCount) {
      acc.push(monitorsSortedByStatus.slice(i, i + rowCount));
    }
    return acc;
  }, [monitorsSortedByStatus, rowCount]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: isUnGrouped ? {
      height: listHeight
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, isUnGrouped ? loaded && monitorsSortedByStatus.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiAutoSizer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, ({
    width
  }) => /*#__PURE__*/_react.default.createElement(_reactWindowInfiniteLoader.default, {
    isItemLoaded: idx => listItems[idx].every(m => !!trendData[m.configId + m.locationId]),
    itemCount: listItems.length,
    loadMoreItems: (_, stop) => setMaxItem(Math.max(maxItem, stop)),
    minimumBatchSize: MIN_BATCH_SIZE,
    threshold: LIST_THRESHOLD,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 17
    }
  }, ({
    onItemsRendered,
    ref
  }) => {
    // set min row count to based on width to ensure cards are not too small
    // min is 1 and max is 5
    setRowCount(Math.max(1, Math.min(5, Math.floor(width / MIN_CARD_WIDTH))));
    return /*#__PURE__*/_react.default.createElement(_reactWindow.FixedSizeList
    // pad computed height to avoid clipping last row's drop shadow
    , {
      height: listHeight + 16,
      width: width,
      onItemsRendered: onItemsRendered,
      itemSize: ITEM_HEIGHT,
      itemCount: listItems.length,
      itemData: listItems,
      ref: ref,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 23
      }
    }, ({
      index: listIndex,
      style,
      data: listData
    }) => {
      setCurrentIndex(listIndex);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        "data-test-subj": `overview-grid-row-${listIndex}`,
        gutterSize: "m",
        css: {
          ...style,
          marginLeft: 5
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 29
        }
      }, listData[listIndex].map((_, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        "data-test-subj": "syntheticsOverviewGridItem",
        key: listIndex * rowCount + idx,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 33
        }
      }, /*#__PURE__*/_react.default.createElement(_metric_item.MetricItem, {
        monitor: monitorsSortedByStatus[listIndex * rowCount + idx],
        onClick: setFlyoutConfigCallback,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 35
        }
      }))), listData[listIndex].length % rowCount !== 0 &&
      // Adds empty items to fill out row
      Array.from({
        length: rowCount - listData[listIndex].length
      }).map((_, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: idx,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 52
        }
      })));
    });
  })) : /*#__PURE__*/_react.default.createElement(_overview_loader.OverviewLoader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_grid_items_by_group.GridItemsByGroup, {
    setFlyoutConfigCallback: setFlyoutConfigCallback,
    view: view,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_cards_view_footer.CardsViewFooter, {
    monitorsSortedByStatus: monitorsSortedByStatus,
    currentIndex: currentIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }));
};
exports.OverviewCardView = OverviewCardView;