"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorBarSeries = void 0;
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/compact_view/components/monitor_bar_series.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const seriesHasDownValues = series => {
  return series ? series.some(point => !!point.down) : false;
};
/**
 * There is a specific focus on the monitor's down count, the up series is not shown,
 * so we will only render the series component if there are down counts for the selected monitor.
 * @param props - the values for the monitor this chart visualizes
 */
const MonitorBarSeries = ({
  histogramSeries,
  minInterval
}) => {
  const {
    services: {
      charts
    }
  } = (0, _public.useKibana)();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const theme = (0, _eui.useEuiTheme)();
  const danger = theme.euiTheme.colors.danger;
  const id = 'downSeries';
  return seriesHasDownValues(histogramSeries) ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: 50,
      width: '100%',
      maxWidth: '1200px',
      marginRight: 15
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    xDomain: {
      minInterval,
      min: (0, _moment.default)().subtract(24, 'hours').valueOf(),
      max: (0, _moment.default)().valueOf()
    },
    locale: _i18n.i18n.getLocale(),
    baseTheme: baseTheme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    hide: true,
    id: "bottom",
    position: _charts.Position.Bottom,
    tickFormat: d => (0, _moment.default)(d).format('YYYY-MM-DD HH:mm:ss'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: id,
    color: danger,
    data: (histogramSeries || []).map(({
      timestamp,
      down
    }) => [timestamp, down]),
    name: _i18n.i18n.translate('xpack.synthetics.monitorList.downLineSeries.downLabel', {
      defaultMessage: 'Down checks'
    }),
    timeZone: "local",
    xAccessor: 0
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yAccessors: [1],
    yScaleType: _charts.ScaleType.Linear,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorList.noDownHistory",
      defaultMessage: "This monitor has never been {emphasizedText} during the last 24 hours",
      values: {
        emphasizedText: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 84,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.synthetics.monitorBarSeries.strong.downLabel', {
          defaultMessage: 'down'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "success",
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.synthetics.monitorBarSeries.TextLabel', {
    defaultMessage: '--'
  })));
};
exports.MonitorBarSeries = MonitorBarSeries;