"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorManagementPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _monitors_mws_callout = require("../common/mws_callout/monitors_mws_callout");
var _disabled_callout = require("./management/disabled_callout");
var _use_overview_status = require("./hooks/use_overview_status");
var _constants = require("../../../../../common/constants");
var _hooks = require("../../hooks");
var _loader = require("./management/loader/loader");
var _use_enablement = require("../../hooks/use_enablement");
var _synthetics_enablement = require("./management/synthetics_enablement/synthetics_enablement");
var _monitor_list_container = require("./management/monitor_list_container");
var _use_breadcrumbs = require("./hooks/use_breadcrumbs");
var _use_monitor_list = require("./hooks/use_monitor_list");
var labels = _interopRequireWildcard(require("./management/labels"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/monitors_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorManagementPage = () => {
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'monitors'
  });
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'monitors',
    delay: 15000
  });
  (0, _use_breadcrumbs.useMonitorListBreadcrumbs)();
  const {
    error: enablementError,
    isEnabled,
    loading: enablementLoading
  } = (0, _use_enablement.useEnablement)();
  (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: false
  });
  const monitorListProps = (0, _use_monitor_list.useMonitorList)();
  const {
    syntheticsMonitors,
    loading: monitorsLoading,
    absoluteTotal,
    loaded
  } = monitorListProps;
  const {
    loading: locationsLoading
  } = (0, _hooks.useLocations)();
  const showEmptyState = isEnabled !== undefined && syntheticsMonitors.length === 0;
  if (isEnabled && !monitorsLoading && absoluteTotal === 0 && loaded) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.GETTING_STARTED_ROUTE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    loading: enablementLoading || locationsLoading,
    error: Boolean(enablementError),
    loadingTitle: labels.LOADING_LABEL,
    errorTitle: labels.ERROR_HEADING_LABEL,
    errorBody: labels.ERROR_HEADING_BODY,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_disabled_callout.DisabledCallout, {
    total: absoluteTotal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_monitors_mws_callout.MonitorsMWsCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor_list_container.MonitorListContainer, {
    isEnabled: isEnabled,
    monitorListProps: monitorListProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })), showEmptyState && /*#__PURE__*/_react.default.createElement(_synthetics_enablement.EnablementEmptyState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 26
    }
  }));
};
exports.MonitorManagementPage = MonitorManagementPage;