"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMonitorDetailsRoute = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _monitor_detail_alerts = require("./monitor_alerts/monitor_detail_alerts");
var _alerts_icon = require("./monitor_alerts/alerts_icon");
var _monitor_not_found_page = require("./monitor_not_found_page");
var _monitor_details_page_title = require("./monitor_details_page_title");
var _monitor_details_last_run = require("./monitor_details_last_run");
var _monitor_details_status = require("./monitor_details_status");
var _monitor_details_location = require("./monitor_details_location");
var _monitor_errors = require("./monitor_errors/monitor_errors");
var _errors_icon = require("./monitor_errors/errors_icon");
var _monitor_history = require("./monitor_history/monitor_history");
var _monitor_summary = require("./monitor_summary/monitor_summary");
var _actions = require("./actions");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/route_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getMonitorDetailsRoute = (history, syntheticsPath, baseTitle) => {
  return [{
    title: _i18n.i18n.translate('xpack.synthetics.monitorDetails.title', {
      defaultMessage: 'Synthetics Monitor Details | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_ROUTE,
    component: _monitor_summary.MonitorSummary,
    dataTestSubj: 'syntheticsMonitorDetailsPage',
    pageHeader: getMonitorSummaryHeader(history, syntheticsPath, 'overview')
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.monitorHistory.title', {
      defaultMessage: 'Synthetics Monitor History | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_HISTORY_ROUTE,
    component: _monitor_history.MonitorHistory,
    dataTestSubj: 'syntheticsMonitorHistoryPage',
    pageHeader: getMonitorSummaryHeader(history, syntheticsPath, 'history')
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.monitorErrors.title', {
      defaultMessage: 'Synthetics Monitor Errors | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_ERRORS_ROUTE,
    component: _monitor_errors.MonitorErrors,
    dataTestSubj: 'syntheticsMonitorHistoryPage',
    pageHeader: getMonitorSummaryHeader(history, syntheticsPath, 'errors')
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.monitorErrors.title', {
      defaultMessage: 'Synthetics Monitor Alerts | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_ALERTS_ROUTE,
    component: _monitor_detail_alerts.MonitorDetailsAlerts,
    dataTestSubj: 'syntheticsMonitorAlertsPage',
    pageHeader: getMonitorSummaryHeader(history, syntheticsPath, 'alerts')
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.monitorNotFound.title', {
      defaultMessage: 'Synthetics Monitor Not Found | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_NOT_FOUND_ROUTE,
    component: _monitor_not_found_page.MonitorNotFoundPage,
    dataTestSubj: 'syntheticsMonitorNotFoundPage',
    pageHeader: {
      breadcrumbs: [getMonitorsBreadcrumb(syntheticsPath)]
    }
  }];
};
exports.getMonitorDetailsRoute = getMonitorDetailsRoute;
const getMonitorsBreadcrumb = syntheticsPath => ({
  text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "arrowLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorSummaryRoute.monitorBreadcrumb",
    defaultMessage: "Monitors",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  })),
  color: 'primary',
  'aria-current': false,
  href: `${syntheticsPath}${_constants.MONITORS_ROUTE}`
});
const getMonitorSummaryHeader = (history, syntheticsPath, selectedTab) => {
  // Not a component, but it doesn't matter. Hooks are just functions
  const match = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ROUTE); // eslint-disable-line react-hooks/rules-of-hooks

  if (!match) {
    return {};
  }
  const search = history.location.search;
  const monitorId = match.params.monitorId;
  const rightSideItems = [/*#__PURE__*/_react.default.createElement(_actions.Actions, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor_details_last_run.MonitorDetailsLastRun, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor_details_status.MonitorDetailsStatus, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor_details_location.MonitorDetailsLocation, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 5
    }
  })];
  return {
    pageTitle: /*#__PURE__*/_react.default.createElement(_monitor_details_page_title.MonitorDetailsPageTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 16
      }
    }),
    breadcrumbs: [getMonitorsBreadcrumb(syntheticsPath)],
    rightSideItems,
    tabs: [{
      label: _i18n.i18n.translate('xpack.synthetics.monitorOverviewTab.title', {
        defaultMessage: 'Overview'
      }),
      isSelected: selectedTab === 'overview',
      href: `${syntheticsPath}${_constants.MONITOR_ROUTE.replace(':monitorId?', monitorId)}${search}`,
      'data-test-subj': 'syntheticsMonitorOverviewTab'
    }, {
      label: _i18n.i18n.translate('xpack.synthetics.monitorHistoryTab.title', {
        defaultMessage: 'History'
      }),
      isSelected: selectedTab === 'history',
      href: `${syntheticsPath}${_constants.MONITOR_HISTORY_ROUTE.replace(':monitorId', monitorId)}${search}`,
      'data-test-subj': 'syntheticsMonitorHistoryTab'
    }, {
      label: _i18n.i18n.translate('xpack.synthetics.monitorErrorsTab.title', {
        defaultMessage: 'Errors'
      }),
      prepend: /*#__PURE__*/_react.default.createElement(_errors_icon.MonitorErrorsIcon, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 18
        }
      }),
      isSelected: selectedTab === 'errors',
      href: `${syntheticsPath}${_constants.MONITOR_ERRORS_ROUTE.replace(':monitorId', monitorId)}${search}`,
      'data-test-subj': 'syntheticsMonitorErrorsTab'
    }, {
      label: _i18n.i18n.translate('xpack.synthetics.monitorAlertsTab.title', {
        defaultMessage: 'Alerts'
      }),
      prepend: /*#__PURE__*/_react.default.createElement(_alerts_icon.MonitorAlertsIcon, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 18
        }
      }),
      isSelected: selectedTab === 'alerts',
      href: `${syntheticsPath}${_constants.MONITOR_ALERTS_ROUTE.replace(':monitorId', monitorId)}${search}`,
      'data-test-subj': 'syntheticsMonitorAlertsTab'
    }]
  };
};