"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDurationTrend = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_monitor_query_filters = require("../hooks/use_monitor_query_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_summary/duration_trend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorDurationTrend = props => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const {
    queryIdFilter,
    locationFilter
  } = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  if (!queryIdFilter) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: "monitorDurationTrend",
    customHeight: "240px",
    reportType: "kpi-over-time",
    attributes: Object.keys(metricsToShow).map(metric => ({
      dataType: 'synthetics',
      time: props,
      name: metricsToShow[metric],
      selectedMetricField: 'monitor.duration.us',
      reportDefinitions: queryIdFilter,
      filters: locationFilter,
      seriesType: 'line',
      operationType: metric
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
};
exports.MonitorDurationTrend = MonitorDurationTrend;
const MIN_LABEL = _i18n.i18n.translate('xpack.synthetics.durationTrend.min', {
  defaultMessage: 'Min'
});
const MAX_LABEL = _i18n.i18n.translate('xpack.synthetics.durationTrend.max', {
  defaultMessage: 'Max'
});
const MEDIAN_LABEL = _i18n.i18n.translate('xpack.synthetics.durationTrend.median', {
  defaultMessage: 'Median'
});
const PERCENTILE_25_LABEL = _i18n.i18n.translate('xpack.synthetics.durationTrend.percentile25', {
  defaultMessage: '25th'
});
const PERCENTILE_75_LABEL = _i18n.i18n.translate('xpack.synthetics.durationTrend.percentile75', {
  defaultMessage: '75th'
});
const metricsToShow = {
  max: MAX_LABEL,
  '75th': PERCENTILE_75_LABEL,
  median: MEDIAN_LABEL,
  '25th': PERCENTILE_25_LABEL,
  min: MIN_LABEL
};