"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorSearchableList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _use_recently_viewed_monitors = require("./use_recently_viewed_monitors");
var _use_monitor_name = require("../../../hooks/use_monitor_name");
var _use_selected_location = require("../hooks/use_selected_location");
var _add_monitor = require("../../common/links/add_monitor");
var _contexts = require("../../../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_selector/monitor_searchable_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorSearchableList = ({
  closePopover
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    recentMonitorOptions,
    loading: recentMonitorsLoading
  } = (0, _use_recently_viewed_monitors.useRecentlyViewedMonitors)();
  const [options, setOptions] = (0, _react.useState)([]);
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    values,
    loading: searchLoading
  } = (0, _use_monitor_name.useMonitorName)({
    search: searchValue
  });
  (0, _react.useEffect)(() => {
    const newOptions = [];
    if (recentMonitorOptions.length > 0 && !searchValue) {
      const otherMonitors = values.filter(value => recentMonitorOptions.every(recent => recent.key !== value.key));
      if (otherMonitors.length > 0) {
        newOptions.push({
          key: 'monitors',
          label: OTHER_MONITORS,
          isGroupLabel: true,
          locationIds: []
        });
      }
      setOptions([...recentMonitorOptions, ...newOptions, ...otherMonitors]);
    } else {
      setOptions(values);
    }
  }, [recentMonitorOptions, searchValue, values]);
  const getLocationId = option => {
    var _option$locationIds, _selectedLocation$id, _option$locationIds2;
    if ((_option$locationIds = option.locationIds) !== null && _option$locationIds !== void 0 && _option$locationIds.includes((_selectedLocation$id = selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id) !== null && _selectedLocation$id !== void 0 ? _selectedLocation$id : '')) {
      return selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id;
    }
    return (_option$locationIds2 = option.locationIds) === null || _option$locationIds2 === void 0 ? void 0 : _option$locationIds2[0];
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    isLoading: searchLoading || recentMonitorsLoading,
    searchProps: {
      placeholder: PLACEHOLDER,
      compressed: true,
      onChange: val => setSearchValue(val),
      autoFocus: true
    },
    options: options,
    onChange: selectedOptions => {
      setOptions(selectedOptions);
      const option = selectedOptions.find(opt => opt.checked === 'on');
      if (option) {
        history.push(`/monitor/${option.key}?locationId=${getLocationId(option)}`);
      }
      closePopover();
    },
    singleSelection: true,
    listProps: {
      showIcons: false
    },
    renderOption: (option, search) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsMonitorSearchableListLink",
      href: `${basePath}/app/synthetics/monitor/${option.key}?locationId=${getLocationId(option)}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 11
      }
    }, option.label)),
    noMatchesMessage: NO_RESULT_FOUND,
    emptyMessage: /*#__PURE__*/_react.default.createElement(_add_monitor.AddMonitorLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 21
      }
    }),
    loadingMessage: LOADING_MONITORS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 280
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, options.length > 0 || searchValue || searchLoading || recentMonitorsLoading ? search : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    className: "eui-textCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, NO_OTHER_MONITORS_EXISTS)), list));
};
exports.MonitorSearchableList = MonitorSearchableList;
const LOADING_MONITORS = _i18n.i18n.translate('xpack.synthetics.monitorSummary.loadingMonitors', {
  defaultMessage: 'Loading monitors'
});
const NO_OTHER_MONITORS_EXISTS = _i18n.i18n.translate('xpack.synthetics.monitorSummary.noOtherMonitors', {
  defaultMessage: 'No other monitors exist.'
});
const NO_RESULT_FOUND = _i18n.i18n.translate('xpack.synthetics.monitorSummary.noResultsFound', {
  defaultMessage: 'No monitors found. Try modifying your query.'
});
const PLACEHOLDER = _i18n.i18n.translate('xpack.synthetics.monitorSummary.placeholderSearch', {
  defaultMessage: 'Monitor name or tag'
});
const OTHER_MONITORS = _i18n.i18n.translate('xpack.synthetics.monitorSummary.otherMonitors', {
  defaultMessage: 'Other monitors'
});