"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDetailsLocation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_kibana_space = require("../../../../hooks/use_kibana_space");
var _hooks = require("../../hooks");
var _constants = require("../../../../../common/constants");
var _plugin = require("../../../../../common/constants/plugin");
var _use_selected_location = require("./hooks/use_selected_location");
var _monitor_location_select = require("../common/components/monitor_location_select");
var _use_selected_monitor = require("./hooks/use_selected_monitor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_details_location.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorDetailsLocation = ({
  isDisabled
}) => {
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const {
    services
  } = (0, _public.useKibana)();
  const isErrorsTab = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ERRORS_ROUTE);
  const isHistoryTab = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_HISTORY_ROUTE);
  const isAlertsTab = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ALERTS_ROUTE);
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const {
    spaceId
  } = (0, _hooks.useGetUrlParams)();
  let params = `&dateRangeStart=${dateRangeStart}&dateRangeEnd=${dateRangeEnd}`;
  if (spaceId && spaceId !== (space === null || space === void 0 ? void 0 : space.id)) {
    params += `&spaceId=${spaceId}`;
  }
  return /*#__PURE__*/_react.default.createElement(_monitor_location_select.MonitorLocationSelect, {
    isDisabled: isDisabled,
    monitorLocations: monitor === null || monitor === void 0 ? void 0 : monitor.locations,
    configId: monitorId,
    selectedLocation: selectedLocation,
    onChange: (0, _react.useCallback)((id, label) => {
      if (isAlertsTab) {
        services.application.navigateToApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID, {
          path: `/monitor/${monitorId}/alerts?locationId=${id}${params}`
        });
      } else if (isErrorsTab) {
        services.application.navigateToApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID, {
          path: `/monitor/${monitorId}/errors?locationId=${id}${params}`
        });
      } else if (isHistoryTab) {
        services.application.navigateToApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID, {
          path: `/monitor/${monitorId}/history/?locationId=${id}${params}`
        });
      } else {
        services.application.navigateToApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID, {
          path: `/monitor/${monitorId}?locationId=${id}${params}`
        });
      }
    }, [isAlertsTab, isErrorsTab, isHistoryTab, monitorId, params, services.application]),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  });
};
exports.MonitorDetailsLocation = MonitorDetailsLocation;