"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorAddPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_clone_monitor = require("./hooks/use_clone_monitor");
var _use_capabilities = require("../../../../hooks/use_capabilities");
var _can_use_public_locations_callout = require("./steps/can_use_public_locations_callout");
var _disabled_callout = require("../monitors_page/management/disabled_callout");
var _hooks = require("../../hooks");
var _state = require("../../state");
var _hooks2 = require("./hooks");
var _steps = require("./steps");
var _form = require("./form");
var _locations_loading_error = require("./locations_loading_error");
var _step_config = require("./steps/step_config");
var _use_breadcrumbs = require("./use_breadcrumbs");
var _monitor_detail_flyout = require("../monitors_page/overview/overview/monitor_detail_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/monitor_add_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorAddPage = () => {
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'add-monitor'
  });
  const {
    space
  } = (0, _hooks2.useKibanaSpace)();
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'add-monitor',
    delay: 15000
  });
  (0, _use_breadcrumbs.useMonitorAddEditBreadcrumbs)();
  (0, _hooks.useEnablement)();
  const canUsePublicLocations = (0, _use_capabilities.useCanUsePublicLocations)();
  const {
    data: cloneMonitor,
    loading: cloneMonitorLoading
  } = (0, _use_clone_monitor.useCloneMonitor)();
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch((0, _state.getServiceLocations)());
  }, [dispatch]);
  const {
    locationsLoaded,
    error: locationsError
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  if (locationsError) {
    return /*#__PURE__*/_react.default.createElement(_locations_loading_error.LocationsLoadingError, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 12
      }
    });
  }
  if (!locationsLoaded || cloneMonitorLoading) {
    return /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_form.MonitorForm, {
    space: space === null || space === void 0 ? void 0 : space.id,
    defaultValues: cloneMonitor ? {
      ...cloneMonitor,
      name: `${cloneMonitor.name} - copy`
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_disabled_callout.DisabledCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_can_use_public_locations_callout.CanUsePublicLocationsCallout, {
    canUsePublicLocations: canUsePublicLocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_steps.MonitorSteps, {
    stepMap: _step_config.ADD_MONITOR_STEPS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }));
};
exports.MonitorAddPage = MonitorAddPage;