"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorSave = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _reactRouterDom = require("react-router-dom");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _constants = require("../../../../../../common/constants");
var _api = require("../../../state/monitor_management/api");
var _kibana_service = require("../../../../../utils/kibana_service");
var _state = require("../../../state");
var _contexts = require("../../../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/hooks/use_monitor_save.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useMonitorSave = ({
  monitorData
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    refreshApp
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    spaceId
  } = (0, _hooks.useGetUrlParams)();
  const editRouteMatch = (0, _reactRouterDom.useRouteMatch)({
    path: _constants.MONITOR_EDIT_ROUTE
  });
  const isEdit = editRouteMatch === null || editRouteMatch === void 0 ? void 0 : editRouteMatch.isExact;
  const {
    data,
    status,
    loading,
    error
  } = (0, _public.useFetcher)(() => {
    if (monitorData) {
      if (isEdit) {
        return (0, _api.updateMonitorAPI)({
          id: monitorId,
          spaceId,
          monitor: monitorData
        });
      } else {
        return (0, _api.createMonitorAPI)({
          monitor: monitorData
        });
      }
    }
    // FIXME: Dario thinks there is a better way to do this but
    // he's getting tired and maybe the Synthetics folks can fix it
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [monitorData]);
  (0, _react.useEffect)(() => {
    const {
      coreStart,
      toasts
    } = _kibana_service.kibanaService;
    if (status === _public.FETCH_STATUS.FAILURE && error) {
      var _body$message;
      toasts.addError({
        ...error,
        message: (_body$message = error.body.message) !== null && _body$message !== void 0 ? _body$message : error.message
      }, {
        title: MONITOR_FAILURE_LABEL
      });
    } else if (status === _public.FETCH_STATUS.SUCCESS && !loading) {
      refreshApp();
      dispatch((0, _state.cleanMonitorListState)());
      toasts.addSuccess({
        title: monitorId ? MONITOR_UPDATED_SUCCESS_LABEL : MONITOR_SUCCESS_LABEL,
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "synthetcsMonitorSaveSubtext",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 68,
            columnNumber: 11
          }
        }, monitorId ? MONITOR_UPDATED_SUCCESS_LABEL_SUBTEXT : MONITOR_SUCCESS_LABEL_SUBTEXT), coreStart),
        toastLifeTimeMs: 3000
      });
    }
  }, [data, status, monitorId, loading, refreshApp, dispatch, error]);
  return {
    status,
    loading,
    isEdit
  };
};
exports.useMonitorSave = useMonitorSave;
const MONITOR_SUCCESS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorAddedSuccessMessage', {
  defaultMessage: 'Monitor added successfully.'
});
const MONITOR_SUCCESS_LABEL_SUBTEXT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorAddedSuccessMessage.subtext', {
  defaultMessage: 'It will next run according to its defined schedule.'
});
const MONITOR_UPDATED_SUCCESS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorEditedSuccessMessage', {
  defaultMessage: 'Monitor updated successfully.'
});
const MONITOR_FAILURE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorFailureMessage', {
  defaultMessage: 'Monitor was unable to be saved. Please try again later.'
});
const MONITOR_UPDATED_SUCCESS_LABEL_SUBTEXT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorFailureMessage.subtext', {
  defaultMessage: 'It will next run according to its defined schedule.'
});