"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlledField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _reactHookForm = require("react-hook-form");
var _hooks = require("../hooks");
var _state = require("../../../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/form/controlled_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ControlledField = ({
  component: FieldComponent,
  props,
  fieldKey,
  field,
  formRowProps,
  error,
  dependenciesValues,
  dependenciesFieldMeta,
  isInvalid
}) => {
  const {
    setValue,
    getFieldState,
    reset,
    formState,
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const {
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const {
    space
  } = (0, _hooks.useKibanaSpace)();
  const isEdit = (0, _hooks.useIsEditFlow)();
  const [onChangeArgs, setOnChangeArgs] = (0, _react.useState)(undefined);
  (0, _useDebounce.default)(async () => {
    if (onChangeArgs !== undefined) {
      await (trigger === null || trigger === void 0 ? void 0 : trigger()); // Manually invalidate whole form to make dependency validations reactive
    }
  }, 500, [onChangeArgs]);
  const handleChange = (0, _react.useCallback)(async (...event) => {
    if (typeof (event === null || event === void 0 ? void 0 : event[0]) === 'string' && !getFieldState(fieldKey).isTouched) {
      // This is needed for composite fields like code editors
      setValue(fieldKey, event[0], {
        shouldTouch: true
      });
    }
    field.onChange(...event);
    setOnChangeArgs(event);
  },
  // Do not depend on `field`
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [setOnChangeArgs]);
  const generatedProps = props ? props({
    field,
    setValue,
    trigger,
    reset,
    locations: locations.map(location => ({
      ...location,
      key: location.id
    })),
    dependencies: dependenciesValues,
    dependenciesFieldMeta,
    space: space === null || space === void 0 ? void 0 : space.id,
    isEdit,
    formState
  }) : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, formRowProps, {
    isInvalid: isInvalid,
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(FieldComponent, (0, _extends2.default)({}, field, {
    checked: field.value || false,
    defaultValue: field.value,
    onChange: handleChange
  }, generatedProps, {
    isInvalid: isInvalid,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  })));
};
exports.ControlledField = ControlledField;