"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrottlingFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _throttling_upload_field = require("./throttling_upload_field");
var _throttling_exceeded_callout = require("./throttling_exceeded_callout");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _throttling_disabled_callout = require("./throttling_disabled_callout");
var _throttling_download_field = require("./throttling_download_field");
var _throttling_latency_field = require("./throttling_latency_field");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/fields/throttling/throttling_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ThrottlingFields = exports.ThrottlingFields = /*#__PURE__*/(0, _react.memo)(({
  validate,
  onFieldBlur,
  setValue,
  readOnly = false,
  throttling
}) => {
  var _throttling$value, _throttling$value2;
  const maxDownload = _runtime_types.DEFAULT_BANDWIDTH_LIMIT[_runtime_types.BandwidthLimitKey.DOWNLOAD];
  const maxUpload = _runtime_types.DEFAULT_BANDWIDTH_LIMIT[_runtime_types.BandwidthLimitKey.UPLOAD];
  const handleInputChange = (0, _react.useCallback)(({
    value,
    configKey
  }) => {
    setValue({
      ...throttling,
      value: {
        ...throttling.value,
        [configKey]: value
      },
      label: _constants.CUSTOM_LABEL,
      id: _constants.PROFILE_VALUES_ENUM.CUSTOM
    });
  }, [setValue, throttling]);
  const exceedsDownloadLimits = Number((_throttling$value = throttling.value) === null || _throttling$value === void 0 ? void 0 : _throttling$value.download) > maxDownload;
  const exceedsUploadLimits = Number((_throttling$value2 = throttling.value) === null || _throttling$value2 === void 0 ? void 0 : _throttling$value2.upload) > maxUpload;
  const isThrottlingEnabled = throttling.id !== _constants.PROFILE_VALUES_ENUM.NO_THROTTLING;
  const hasExceededLimits = isThrottlingEnabled && (exceedsDownloadLimits || exceedsUploadLimits);
  if (!isThrottlingEnabled || !throttling.value) {
    return /*#__PURE__*/_react.default.createElement(_throttling_disabled_callout.ThrottlingDisabledCallout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, hasExceededLimits && /*#__PURE__*/_react.default.createElement(_throttling_exceeded_callout.ThrottlingExceededCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 31
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_throttling_download_field.ThrottlingDownloadField, {
    validate: validate,
    onFieldBlur: onFieldBlur,
    throttling: throttling,
    throttlingValue: throttling.value,
    handleInputChange: val => {
      handleInputChange({
        value: val,
        configKey: 'download'
      });
    },
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_throttling_upload_field.ThrottlingUploadField, {
    throttlingValue: throttling.value,
    validate: validate,
    onFieldBlur: onFieldBlur,
    throttling: throttling,
    handleInputChange: val => {
      handleInputChange({
        value: val,
        configKey: 'upload'
      });
    },
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_throttling_latency_field.ThrottlingLatencyField, {
    throttlingValue: throttling.value,
    validate: validate,
    onFieldBlur: onFieldBlur,
    throttling: throttling,
    handleInputChange: val => {
      handleInputChange({
        value: val,
        configKey: 'latency'
      });
    },
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }));
});