"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormattedComboBox = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/fields/combo_box.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FormattedComboBox = ({
  onChange,
  onBlur,
  selectedOptions,
  ...props
}) => {
  const [formattedSelectedOptions, setSelectedOptions] = (0, _react.useState)(selectedOptions.map(option => ({
    label: option,
    key: option
  })));
  const [isInvalid, setInvalid] = (0, _react.useState)(false);
  const onOptionsChange = (0, _react.useCallback)(options => {
    setSelectedOptions(options);
    const formattedTags = options.map(option => option.label);
    onChange(formattedTags);
    setInvalid(false);
  }, [onChange, setSelectedOptions, setInvalid]);
  const onCreateOption = (0, _react.useCallback)(tag => {
    const formattedTag = tag.trim();
    const newOption = {
      label: formattedTag
    };
    onChange([...selectedOptions, formattedTag]);

    // Select the option.
    setSelectedOptions([...formattedSelectedOptions, newOption]);
  }, [onChange, formattedSelectedOptions, selectedOptions, setSelectedOptions]);
  const onSearchChange = (0, _react.useCallback)(searchValue => {
    if (!searchValue) {
      setInvalid(false);
      return;
    }
    setInvalid(!isValid(searchValue));
  }, [setInvalid]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    "data-test-subj": "syntheticsFleetComboBox",
    noSuggestions: true,
    selectedOptions: formattedSelectedOptions,
    onCreateOption: onCreateOption,
    onChange: onOptionsChange,
    onBlur: () => onBlur === null || onBlur === void 0 ? void 0 : onBlur(),
    onSearchChange: onSearchChange,
    isInvalid: isInvalid
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }));
};
exports.FormattedComboBox = FormattedComboBox;
const isValid = value => {
  // Ensure that the tag is more than whitespace
  return value.match(/\S+/) !== null;
};