"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorDuration = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _use_error_failed_tests = require("../hooks/use_error_failed_tests");
var _use_find_my_killer_state = require("../hooks/use_find_my_killer_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/error_details/components/error_duration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ErrorDuration = () => {
  var _failedTests$;
  const {
    failedTests
  } = (0, _use_error_failed_tests.useErrorFailedTests)();
  const state = failedTests === null || failedTests === void 0 ? void 0 : (_failedTests$ = failedTests[0]) === null || _failedTests$ === void 0 ? void 0 : _failedTests$.state;
  const {
    killerState
  } = (0, _use_find_my_killer_state.useFindMyKillerState)();
  const endsAt = killerState !== null && killerState !== void 0 && killerState['@timestamp'] ? (0, _moment.default)(killerState === null || killerState === void 0 ? void 0 : killerState['@timestamp']) : (0, _moment.default)();
  const startedAt = (0, _moment.default)(state === null || state === void 0 ? void 0 : state.started_at);
  const duration = state ? getErrorDuration(startedAt, endsAt) : 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: ERROR_DURATION,
      description: duration
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 10
    }
  });
};
exports.ErrorDuration = ErrorDuration;
const ERROR_DURATION = _i18n.i18n.translate('xpack.synthetics.errorDetails.errorDuration', {
  defaultMessage: 'Error duration'
});
const getErrorDuration = (startedAt, endsAt) => {
  // const endsAt = state.ends ? moment(state.ends) : moment();
  // const startedAt = moment(state?.started_at);

  const diffInDays = endsAt.diff(startedAt, 'days');
  if (diffInDays > 1) {
    return _i18n.i18n.translate('xpack.synthetics.errorDetails.errorDuration.days', {
      defaultMessage: '{value} days',
      values: {
        value: diffInDays
      }
    });
  }
  const diffInHours = endsAt.diff(startedAt, 'hours');
  if (diffInHours > 1) {
    return _i18n.i18n.translate('xpack.synthetics.errorDetails.errorDuration.hours', {
      defaultMessage: '{value} hours',
      values: {
        value: diffInHours
      }
    });
  }
  const diffInMinutes = endsAt.diff(startedAt, 'minutes');
  return _i18n.i18n.translate('xpack.synthetics.errorDetails.errorDuration.mins', {
    defaultMessage: '{value} mins',
    values: {
      value: diffInMinutes
    }
  });
};