"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JourneyLastScreenshot = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_journey_steps = require("../../monitor_details/hooks/use_journey_steps");
var _status_badge = require("../monitor_test_result/status_badge");
var _journey_step_screenshot_container = require("./journey_step_screenshot_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/screenshot/journey_last_screenshot.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JourneyLastScreenshot = ({
  checkGroupId,
  size,
  timestamp
}) => {
  var _lastSignificantStep$, _lastSignificantStep$2, _lastSignificantStep$3;
  const {
    loading: stepsLoading,
    stepEnds
  } = (0, _use_journey_steps.useJourneySteps)(checkGroupId);
  const lastSignificantStep = (0, _react.useMemo)(() => {
    const copy = [...stepEnds];
    // Sort desc by timestamp
    copy.sort((stepA, stepB) => Number(new Date(stepB['@timestamp'])) - Number(new Date(stepA['@timestamp'])));
    return copy.find(stepEnd => {
      var _stepEnd$synthetics$s, _stepEnd$synthetics, _stepEnd$synthetics$s2;
      return (0, _status_badge.parseBadgeStatus)((_stepEnd$synthetics$s = stepEnd === null || stepEnd === void 0 ? void 0 : (_stepEnd$synthetics = stepEnd.synthetics) === null || _stepEnd$synthetics === void 0 ? void 0 : (_stepEnd$synthetics$s2 = _stepEnd$synthetics.step) === null || _stepEnd$synthetics$s2 === void 0 ? void 0 : _stepEnd$synthetics$s2.status) !== null && _stepEnd$synthetics$s !== void 0 ? _stepEnd$synthetics$s : 'skipped') !== 'skipped';
    });
  }, [stepEnds]);
  return /*#__PURE__*/_react.default.createElement(_journey_step_screenshot_container.JourneyStepScreenshotContainer, {
    checkGroup: lastSignificantStep === null || lastSignificantStep === void 0 ? void 0 : lastSignificantStep.monitor.check_group,
    initialStepNumber: lastSignificantStep === null || lastSignificantStep === void 0 ? void 0 : (_lastSignificantStep$ = lastSignificantStep.synthetics) === null || _lastSignificantStep$ === void 0 ? void 0 : (_lastSignificantStep$2 = _lastSignificantStep$.step) === null || _lastSignificantStep$2 === void 0 ? void 0 : _lastSignificantStep$2.index,
    stepStatus: lastSignificantStep === null || lastSignificantStep === void 0 ? void 0 : (_lastSignificantStep$3 = lastSignificantStep.synthetics.payload) === null || _lastSignificantStep$3 === void 0 ? void 0 : _lastSignificantStep$3.status,
    allStepsLoaded: !stepsLoading,
    retryFetchOnRevisit: false,
    size: size,
    timestamp: timestamp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  });
};
exports.JourneyLastScreenshot = JourneyLastScreenshot;