"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BrowserStepsList = void 0;
exports.isStepEnd = isStepEnd;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _step_tabs = require("../../test_run_details/step_tabs");
var _result_details = require("./result_details");
var _journey_step_screenshot_container = require("../screenshot/journey_step_screenshot_container");
var _screenshot_size = require("../screenshot/screenshot_size");
var _step_details_link = require("../links/step_details_link");
var _status_badge = require("./status_badge");
var _step_duration_text = require("./step_duration_text");
var _result_details_successful = require("./result_details_successful");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/monitor_test_result/browser_steps_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isStepEnd(step) {
  var _step$synthetics;
  return ((_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : _step$synthetics.type) === 'step/end';
}
function toExpandedMapItem(step, stepsList, testNowMode) {
  if (testNowMode) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_step_tabs.StepTabs, {
      step: step,
      loading: false,
      stepsList: stepsList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
}
function mapStepIds(steps) {
  return steps.map(({
    _id
  }) => _id).toString();
}
const MAX_STEPS_TO_SHOW = 5;
const BrowserStepsList = ({
  steps,
  error,
  loading,
  screenshotImageSize = _screenshot_size.THUMBNAIL_SCREENSHOT_SIZE,
  showLastSuccessful = true,
  showStepNumber = false,
  compressed = true,
  showExpand = true,
  testNowMode = false
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const allStepEnds = steps.filter(isStepEnd);
  const failedStep = allStepEnds.find(step => {
    var _step$synthetics$step;
    return ((_step$synthetics$step = step.synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.status) === 'failed';
  });
  const shouldPaginate = allStepEnds.length > MAX_STEPS_TO_SHOW;
  const stepEnds = shouldPaginate ? allStepEnds.slice(pageIndex * MAX_STEPS_TO_SHOW, Math.min(pageIndex * MAX_STEPS_TO_SHOW + MAX_STEPS_TO_SHOW, allStepEnds.length)) : allStepEnds;
  const pagination = shouldPaginate ? {
    pageIndex,
    pageSize: MAX_STEPS_TO_SHOW,
    totalItemCount: allStepEnds.length,
    showPerPageOptions: false
  } : undefined;
  const onTableChange = ({
    page
  }) => {
    if (page) {
      setPageIndex(page.index);
    }
  };
  /**
   * This component is used in cases where the steps list is not pre-fetched at render time. In that case, we handle the auto-expand
   * in the `useEffect` call below, which will update the expanded map after the data loads. At times, the component is also rendered
   * with the complete list of steps pre-loaded. In that case, we must set the default state value to pre-expand for the error step.
   */
  const defaultExpanded = (0, _react.useMemo)(() => !!failedStep && showExpand ? {
    [failedStep._id]: toExpandedMapItem(failedStep, steps, testNowMode)
  } : {}, [failedStep, showExpand, steps, testNowMode]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [expandedMap, setExpandedMap] = (0, _react.useState)(defaultExpanded);
  const [stepIds, setStepIds] = (0, _react.useState)(mapStepIds(stepEnds));
  (0, _react.useEffect)(() => {
    /**
     * This effect will only take action when the set of steps changes.
     */
    const latestIds = mapStepIds(stepEnds);
    if (latestIds !== stepIds) {
      setStepIds(latestIds);
      if (failedStep && showExpand && !expandedMap[failedStep._id]) {
        setExpandedMap(Object.assign(expandedMap, {
          [failedStep._id]: toExpandedMapItem(failedStep, steps, testNowMode)
        }));
      }
    }
  }, [expandedMap, failedStep, showExpand, stepEnds, stepIds, steps, testNowMode]);
  const toggleDetails = (0, _react.useCallback)(item => {
    setExpandedMap(prevState => {
      const expandedMapValues = {
        ...prevState
      };
      if (expandedMapValues[item._id]) {
        delete expandedMapValues[item._id];
      } else {
        expandedMapValues[item._id] = toExpandedMapItem(item, steps, testNowMode);
      }
      return expandedMapValues;
    });
  }, [steps, testNowMode]);
  const columns = [...(showExpand ? [{
    align: 'left',
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "syntheticsColumnsButton",
      onClick: () => toggleDetails(item),
      "aria-label": expandedMap[item._id] ? 'Collapse' : 'Expand',
      iconType: expandedMap[item._id] ? 'arrowDown' : 'arrowRight',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 15
      }
    })
  }] : []), ...(showStepNumber ? [{
    field: 'synthetics.step.index',
    name: '#',
    render: (stepIndex, item) => /*#__PURE__*/_react.default.createElement(StyleForStepStatus, {
      step: item,
      euiTheme: euiTheme,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 15
      }
    }, stepIndex),
    mobileOptions: {
      show: false
    }
  }] : []), {
    align: 'left',
    field: 'timestamp',
    name: SCREENSHOT_LABEL,
    render: (timestamp, step) => {
      var _step$synthetics2, _step$synthetics2$ste, _step$synthetics$payl;
      return /*#__PURE__*/_react.default.createElement(_journey_step_screenshot_container.JourneyStepScreenshotContainer, {
        checkGroup: step.monitor.check_group,
        initialStepNumber: (_step$synthetics2 = step.synthetics) === null || _step$synthetics2 === void 0 ? void 0 : (_step$synthetics2$ste = _step$synthetics2.step) === null || _step$synthetics2$ste === void 0 ? void 0 : _step$synthetics2$ste.index,
        stepStatus: (_step$synthetics$payl = step.synthetics.payload) === null || _step$synthetics$payl === void 0 ? void 0 : _step$synthetics$payl.status,
        allStepsLoaded: !loading,
        retryFetchOnRevisit: true,
        size: screenshotImageSize,
        testNowMode: testNowMode,
        timestamp: timestamp,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 9
        }
      });
    },
    mobileOptions: {
      render: step => /*#__PURE__*/_react.default.createElement(MobileRowDetails, {
        journeyStep: step,
        stepsLoading: loading,
        showStepNumber: showStepNumber,
        showLastSuccessful: showLastSuccessful,
        isExpanded: Boolean(expandedMap[step._id]),
        isTestNowMode: testNowMode,
        euiTheme: euiTheme,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 11
        }
      }),
      header: false,
      enlarge: true,
      width: '100%'
    }
  }, {
    field: 'synthetics.step.name',
    name: STEP_NAME,
    render: (stepName, item) => {
      var _item$synthetics$step, _item$synthetics$step2;
      const status = (0, _status_badge.parseBadgeStatus)((_item$synthetics$step = (_item$synthetics$step2 = item.synthetics.step) === null || _item$synthetics$step2 === void 0 ? void 0 : _item$synthetics$step2.status) !== null && _item$synthetics$step !== void 0 ? _item$synthetics$step : '');
      const textColor = euiTheme.colors[(0, _status_badge.getTextColorForMonitorStatus)(status)];
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: textColor,
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 238,
          columnNumber: 11
        }
      }, stepName);
    },
    mobileOptions: {
      show: false
    }
  }, {
    field: 'synthetics.step.status',
    name: RESULT_LABEL,
    render: (pingStatus, item) => /*#__PURE__*/_react.default.createElement(_result_details.ResultDetails, {
      testNowMode: testNowMode,
      step: item,
      pingStatus: pingStatus,
      isExpanded: Boolean(expandedMap[item._id]) && !testNowMode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 9
      }
    }),
    mobileOptions: {
      show: false
    }
  }, ...(showLastSuccessful ? [{
    field: 'synthetics.step.status',
    name: LAST_SUCCESSFUL,
    render: (pingStatus, item) => /*#__PURE__*/_react.default.createElement(_result_details_successful.ResultDetailsSuccessful, {
      step: item,
      isExpanded: Boolean(expandedMap[item._id]),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 15
      }
    }),
    mobileOptions: {
      show: false
    }
  }] : [{
    align: 'left',
    name: STEP_DURATION,
    render: item => {
      return /*#__PURE__*/_react.default.createElement(_step_duration_text.StepDurationText, {
        step: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 280,
          columnNumber: 22
        }
      });
    },
    mobileOptions: {
      header: STEP_DURATION,
      show: true
    }
  }]), {
    align: 'right',
    field: 'timestamp',
    name: '',
    render: (_val, item) => {
      var _item$synthetics, _item$synthetics$step3;
      return /*#__PURE__*/_react.default.createElement(_step_details_link.StepDetailsLinkIcon, {
        checkGroup: item.monitor.check_group,
        stepIndex: (_item$synthetics = item.synthetics) === null || _item$synthetics === void 0 ? void 0 : (_item$synthetics$step3 = _item$synthetics.step) === null || _item$synthetics$step3 === void 0 ? void 0 : _item$synthetics$step3.index,
        configId: item.config_id,
        target: testNowMode ? '_blank' : undefined,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 293,
          columnNumber: 9
        }
      });
    },
    mobileOptions: {
      show: false
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    cellProps: row => {
      if (expandedMap[row._id]) {
        return {
          style: {
            verticalAlign: 'top'
          }
        };
      }
    },
    compressed: compressed,
    loading: loading,
    columns: columns,
    error: error === null || error === void 0 ? void 0 : error.message,
    items: stepEnds,
    noItemsMessage: loading ? _i18n.i18n.translate('xpack.synthetics.monitor.step.loading', {
      defaultMessage: 'Loading steps...'
    }) : _i18n.i18n.translate('xpack.synthetics.monitor.step.noDataFound', {
      defaultMessage: 'No data found'
    }),
    tableLayout: "auto",
    itemId: "_id",
    itemIdToExpandedRowMap: testNowMode || showExpand ? expandedMap : undefined,
    onChange: onTableChange,
    pagination: pagination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 5
    }
  });
};
exports.BrowserStepsList = BrowserStepsList;
const StyleForStepStatus = ({
  step,
  textSize = 's',
  euiTheme,
  children
}) => {
  var _step$synthetics$step2, _step$synthetics3, _step$synthetics3$ste;
  const status = (0, _status_badge.parseBadgeStatus)((_step$synthetics$step2 = (_step$synthetics3 = step.synthetics) === null || _step$synthetics3 === void 0 ? void 0 : (_step$synthetics3$ste = _step$synthetics3.step) === null || _step$synthetics3$ste === void 0 ? void 0 : _step$synthetics3$ste.status) !== null && _step$synthetics$step2 !== void 0 ? _step$synthetics$step2 : '');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: {
      fontWeight: euiTheme.font.weight.bold,
      whiteSpace: 'nowrap'
    },
    size: textSize,
    color: euiTheme.colors[(0, _status_badge.getTextColorForMonitorStatus)(status)],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 5
    }
  }, children);
};
const MobileRowDetails = ({
  journeyStep,
  showStepNumber,
  showLastSuccessful,
  stepsLoading,
  isExpanded,
  isTestNowMode,
  euiTheme
}) => {
  var _journeyStep$syntheti, _journeyStep$syntheti2, _journeyStep$syntheti3, _journeyStep$syntheti4, _journeyStep$syntheti5, _journeyStep$syntheti6, _journeyStep$syntheti7, _journeyStep$syntheti8, _journeyStep$syntheti9, _journeyStep$syntheti10, _journeyStep$syntheti11, _journeyStep$syntheti12;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StyleForStepStatus, {
    step: journeyStep,
    textSize: "relative",
    euiTheme: euiTheme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 11
    }
  }, showStepNumber && (_journeyStep$syntheti = journeyStep.synthetics) !== null && _journeyStep$syntheti !== void 0 && (_journeyStep$syntheti2 = _journeyStep$syntheti.step) !== null && _journeyStep$syntheti2 !== void 0 && _journeyStep$syntheti2.index ? `${journeyStep.synthetics.step.index}. ` : null, ' ', (_journeyStep$syntheti3 = journeyStep.synthetics) === null || _journeyStep$syntheti3 === void 0 ? void 0 : (_journeyStep$syntheti4 = _journeyStep$syntheti3.step) === null || _journeyStep$syntheti4 === void 0 ? void 0 : _journeyStep$syntheti4.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceEvenly",
    responsive: false,
    wrap: true,
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_journey_step_screenshot_container.JourneyStepScreenshotContainer, {
    checkGroup: journeyStep.monitor.check_group,
    initialStepNumber: (_journeyStep$syntheti5 = journeyStep.synthetics) === null || _journeyStep$syntheti5 === void 0 ? void 0 : (_journeyStep$syntheti6 = _journeyStep$syntheti5.step) === null || _journeyStep$syntheti6 === void 0 ? void 0 : _journeyStep$syntheti6.index,
    stepStatus: (_journeyStep$syntheti7 = journeyStep.synthetics.payload) === null || _journeyStep$syntheti7 === void 0 ? void 0 : _journeyStep$syntheti7.status,
    allStepsLoaded: !stepsLoading,
    retryFetchOnRevisit: true,
    size: _screenshot_size.THUMBNAIL_SCREENSHOT_SIZE_MOBILE,
    timestamp: journeyStep === null || journeyStep === void 0 ? void 0 : journeyStep['@timestamp'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 11
    }
  }, [{
    title: RESULT_LABEL,
    description: /*#__PURE__*/_react.default.createElement(_result_details.ResultDetails, {
      testNowMode: isTestNowMode,
      step: journeyStep,
      pingStatus: (_journeyStep$syntheti8 = journeyStep === null || journeyStep === void 0 ? void 0 : (_journeyStep$syntheti9 = journeyStep.synthetics) === null || _journeyStep$syntheti9 === void 0 ? void 0 : (_journeyStep$syntheti10 = _journeyStep$syntheti9.step) === null || _journeyStep$syntheti10 === void 0 ? void 0 : _journeyStep$syntheti10.status) !== null && _journeyStep$syntheti8 !== void 0 ? _journeyStep$syntheti8 : 'skipped',
      isExpanded: isExpanded && !isTestNowMode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 407,
        columnNumber: 19
      }
    })
  }, ...[showLastSuccessful ? {
    title: LAST_SUCCESSFUL,
    description: /*#__PURE__*/_react.default.createElement(_result_details_successful.ResultDetailsSuccessful, {
      step: journeyStep,
      isExpanded: isExpanded,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 420,
        columnNumber: 25
      }
    })
  } : {
    title: STEP_DURATION,
    description: /*#__PURE__*/_react.default.createElement(_step_duration_text.StepDurationText, {
      step: journeyStep,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 425,
        columnNumber: 36
      }
    })
  }]].map(({
    title,
    description
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: title,
    css: {
      maxWidth: 'fit-content'
    },
    direction: "row",
    alignItems: "baseline",
    gutterSize: "xs",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 17
    }
  }, title), description))))), /*#__PURE__*/_react.default.createElement(_step_details_link.StepDetailsLinkIcon, {
    css: {
      marginLeft: 'auto'
    },
    checkGroup: journeyStep.monitor.check_group,
    stepIndex: (_journeyStep$syntheti11 = journeyStep.synthetics) === null || _journeyStep$syntheti11 === void 0 ? void 0 : (_journeyStep$syntheti12 = _journeyStep$syntheti11.step) === null || _journeyStep$syntheti12 === void 0 ? void 0 : _journeyStep$syntheti12.index,
    configId: journeyStep.config_id,
    asButton: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 445,
      columnNumber: 7
    }
  }));
};
const RESULT_LABEL = _i18n.i18n.translate('xpack.synthetics.monitor.result.label', {
  defaultMessage: 'Result'
});
const LAST_SUCCESSFUL = _i18n.i18n.translate('xpack.synthetics.monitor.result.lastSuccessful', {
  defaultMessage: 'Last successful'
});
const SCREENSHOT_LABEL = _i18n.i18n.translate('xpack.synthetics.monitor.screenshot.label', {
  defaultMessage: 'Screenshot'
});
const STEP_NAME = _i18n.i18n.translate('xpack.synthetics.monitor.stepName.label', {
  defaultMessage: 'Step name'
});
const STEP_DURATION = _i18n.i18n.translate('xpack.synthetics.monitor.step.duration.label', {
  defaultMessage: 'Duration'
});