"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useErrorDetailsLink = exports.ErrorDetailsLink = exports.ErrorDetailsButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_selected_location = require("../../monitor_details/hooks/use_selected_location");
var _contexts = require("../../../contexts");
var _errors_list = require("../../monitor_details/monitor_errors/errors_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/links/error_details_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ErrorDetailsLink = ({
  stateId,
  configId,
  label,
  locationId
}) => {
  const link = useErrorDetailsLink({
    configId,
    stateId,
    locationId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsErrorDetailsLinkLink",
    href: link,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, label !== null && label !== void 0 ? label : VIEW_DETAILS);
};
exports.ErrorDetailsLink = ErrorDetailsLink;
const ErrorDetailsButton = ({
  stateId,
  configId,
  label
}) => {
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const link = useErrorDetailsLink({
    configId,
    stateId,
    locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsErrorDetailsButtonButton",
    flush: "left",
    iconType: "warning",
    color: "danger",
    href: link,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, label !== null && label !== void 0 ? label : VIEW_DETAILS);
};
exports.ErrorDetailsButton = ErrorDetailsButton;
const useErrorDetailsLink = ({
  stateId,
  configId,
  locationId
}) => {
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  return (0, _errors_list.getErrorDetailsUrl)({
    basePath,
    configId,
    stateId,
    locationId
  });
};
exports.useErrorDetailsLink = useErrorDetailsLink;
const VIEW_DETAILS = _i18n.i18n.translate('xpack.synthetics.monitor.step.viewErrorDetails', {
  defaultMessage: 'View error details'
});