"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_IN_DISCOVER_LABEL = exports.TYPE_LABEL = exports.TIMESTAMP_LABEL = exports.TEST_RUN_LOGS_LABEL = exports.StdErrorLogs = exports.ERROR_SUMMARY_LABEL = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_std_error_logs = require("./use_std_error_logs");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/stderr_logs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StdErrorLogs = ({
  checkGroup,
  timestamp,
  title,
  summaryMessage,
  hideTitle = false,
  pageSize = 5
}) => {
  const columns = [{
    field: '@timestamp',
    name: TIMESTAMP_LABEL,
    sortable: true,
    render: date => (0, _eui.formatDate)(date, 'dateTime')
  }, {
    field: 'synthetics.type',
    name: TYPE_LABEL,
    sortable: true
  }, {
    field: 'synthetics.payload.message',
    name: 'Message',
    render: message => /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: message.includes('SyntaxError:') ? 'SyntaxError:' : 'ReferenceError:',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, message)
  }];
  const {
    items,
    loading
  } = (0, _use_std_error_logs.useStdErrorLogs)({
    checkGroup
  });
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize
  });
  const onTableChange = ({
    page
  }) => {
    setPagination({
      pageIndex: page.index,
      pageSize: page.size
    });
  };
  const {
    discover,
    exploratoryView
  } = (0, _public.useKibana)().services;
  const {
    data: discoverLink
  } = (0, _public2.useFetcher)(async () => {
    var _discover$locator;
    const dataView = await exploratoryView.getAppDataView('synthetics', _constants.SYNTHETICS_INDEX_PATTERN);
    return (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.getUrl({
      query: {
        language: 'kuery',
        query: `monitor.check_group: ${checkGroup}`
      },
      indexPatternId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
      columns: ['synthetics.payload.message', 'error.message'],
      timeRange: timestamp ? {
        from: (0, _moment.default)(timestamp).subtract(10, 'minutes').toISOString(),
        to: (0, _moment.default)(timestamp).add(5, 'minutes').toISOString()
      } : undefined
    });
  }, [checkGroup, timestamp, discover, exploratoryView]);
  const search = {
    box: {
      incremental: true
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideTitle && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 17
    }
  }, title !== null && title !== void 0 ? title : TEST_RUN_LOGS_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsStdErrorLogsLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStdErrorLogsButton",
    href: discoverLink,
    iconType: "discoverApp",
    isDisabled: !discoverLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 17
    }
  }, VIEW_IN_DISCOVER_LABEL)))), summaryMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: ERROR_SUMMARY_LABEL,
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 15
    }
  }, summaryMessage))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: items,
    rowHeader: "@timestamp",
    columns: columns,
    tableLayout: "auto",
    loading: loading,
    search: search,
    itemId: "id",
    executeQueryOptions: {
      defaultFields: ['@timestamp', 'synthetics.payload.message']
    },
    pagination: {
      ...pagination,
      pageSizeOptions: [2, 5, 10, 20, 50]
    },
    onTableChange: onTableChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }));
};
exports.StdErrorLogs = StdErrorLogs;
const TIMESTAMP_LABEL = exports.TIMESTAMP_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.timestamp', {
  defaultMessage: 'Timestamp'
});
const TYPE_LABEL = exports.TYPE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.type', {
  defaultMessage: 'Type'
});
const ERROR_SUMMARY_LABEL = exports.ERROR_SUMMARY_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.errorSummary', {
  defaultMessage: 'Error summary'
});
const VIEW_IN_DISCOVER_LABEL = exports.VIEW_IN_DISCOVER_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.viewInDiscover', {
  defaultMessage: 'View in discover'
});
const TEST_RUN_LOGS_LABEL = exports.TEST_RUN_LOGS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.testRunLogs', {
  defaultMessage: 'Test run logs'
});