"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDetailsPanel = void 0;
exports.frequencyStr = frequencyStr;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _use_kibana_space = require("../../../../../hooks/use_kibana_space");
var _panel_with_title = require("./panel_with_title");
var _monitor_enabled = require("../../monitors_page/management/monitor_list_table/monitor_enabled");
var _state = require("../../../state");
var _locations_status = require("../../monitor_details/monitor_summary/locations_status");
var _runtime_types = require("../../../../../../common/runtime_types");
var _monitor_type_badge = require("./monitor_type_badge");
var _use_date_format = require("../../../../../hooks/use_date_format");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/monitor_details_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorDetailsPanel = ({
  monitor,
  latestPing,
  loading,
  configId,
  hideEnabled = false,
  hideLocations = false,
  hasBorder = true
}) => {
  var _latestPing$url$full, _latestPing$url;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const {
    spaceId
  } = (0, _hooks.useGetUrlParams)();
  if (!monitor) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 8,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 12
      }
    });
  }
  const url = (_latestPing$url$full = latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$url = latestPing.url) === null || _latestPing$url === void 0 ? void 0 : _latestPing$url.full) !== null && _latestPing$url$full !== void 0 ? _latestPing$url$full : monitor[_runtime_types.ConfigKey.URLS];
  const labels = monitor[_runtime_types.ConfigKey.LABELS];
  return /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, {
    paddingSize: "m",
    margin: "none",
    title: MONITOR_DETAILS_LABEL,
    titleLeftAlign: true,
    hasBorder: hasBorder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "responsiveColumn",
    columnWidths: [2, 3],
    compressed: true,
    align: "left",
    css: {
      maxWidth: 550
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, !hideEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, ENABLED_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, monitor && /*#__PURE__*/_react.default.createElement(_monitor_enabled.MonitorEnabled, {
    initialLoading: loading,
    configId: configId,
    monitor: monitor,
    reloadPage: () => {
      dispatch(_state.getMonitorAction.get({
        monitorId: configId,
        ...(spaceId && spaceId !== (space === null || space === void 0 ? void 0 : space.id) ? {
          spaceId
        } : {})
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, URL_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    style: {
      wordBreak: 'break-all'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, url ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMonitorDetailsPanelLink",
    href: url,
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, url) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, UN_AVAILABLE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, LAST_RUN_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, latestPing !== null && latestPing !== void 0 && latestPing['@timestamp'] ? /*#__PURE__*/_react.default.createElement(Time, {
    timestamp: latestPing === null || latestPing === void 0 ? void 0 : latestPing['@timestamp'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.synthetics.monitorDetailsPanel.TextLabel', {
    defaultMessage: '--'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, LAST_MODIFIED_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(Time, {
    timestamp: monitor.updated_at,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  })), monitor[_runtime_types.ConfigKey.PROJECT_ID] && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, PROJECT_ID_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, monitor[_runtime_types.ConfigKey.PROJECT_ID])), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }, MONITOR_ID_ITEM_TEXT), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, monitor.id), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, MONITOR_TYPE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_type_badge.MonitorTypeBadge, {
    monitorType: monitor.type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }, FREQUENCY_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, frequencyStr(monitor[_runtime_types.ConfigKey.SCHEDULE])), !hideLocations && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }, LOCATIONS_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_locations_status.LocationsStatus, {
    configId: configId,
    monitorLocations: monitor.locations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, TAGS_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TagsList, {
    tags: monitor[_runtime_types.ConfigKey.TAGS],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  })), !(0, _lodash.isEmpty)(labels) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, LABELS_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }, Object.entries(labels !== null && labels !== void 0 ? labels : {}).map(([key, value]) => /*#__PURE__*/_react.default.createElement("div", {
    key: key,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 19
    }
  }, key), ": ", value)))) : null));
};
exports.MonitorDetailsPanel = MonitorDetailsPanel;
function frequencyStr(frequency) {
  return translateUnitMessage(`${frequency.number} ${unitToString(frequency.unit, parseInt(frequency.number, 10))}`);
}
function unitToString(unit, n) {
  switch (unit) {
    case 's':
      return secondsString(n);
    case 'm':
      return minutesString(n);
    case 'h':
      return hoursString(n);
    case 'd':
      return daysString(n);
    default:
      return unit;
  }
}
const secondsString = n => _i18n.i18n.translate('xpack.synthetics.monitorDetail.seconds', {
  defaultMessage: '{n, plural, one {second} other {seconds}}',
  values: {
    n
  }
});
const minutesString = n => _i18n.i18n.translate('xpack.synthetics.monitorDetail.minutes', {
  defaultMessage: '{n, plural, one {minute} other {minutes}}',
  values: {
    n
  }
});
const hoursString = n => _i18n.i18n.translate('xpack.synthetics.monitorDetail.hours', {
  defaultMessage: '{n, plural, one {hour} other {hours}}',
  values: {
    n
  }
});
const daysString = n => _i18n.i18n.translate('xpack.synthetics.monitorDetail.days', {
  defaultMessage: '{n, plural, one {day} other {days}}',
  values: {
    n
  }
});
function translateUnitMessage(unitMsg) {
  return _i18n.i18n.translate('xpack.synthetics.monitorList.flyout.unitStr', {
    defaultMessage: 'Every {unitMsg}',
    values: {
      unitMsg
    },
    description: 'This displays a message like "Every 10 minutes" or "Every 30 seconds"'
  });
}
const Time = ({
  timestamp
}) => {
  const formatter = (0, _use_date_format.useDateFormat)();
  const dateTimeFormatted = formatter(timestamp);
  return timestamp ? /*#__PURE__*/_react.default.createElement("time", {
    dateTime: timestamp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 22
    }
  }, dateTimeFormatted) : null;
};
const FREQUENCY_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.frequency', {
  defaultMessage: 'Frequency'
});
const LOCATIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.locations', {
  defaultMessage: 'Locations'
});
const URL_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.url', {
  defaultMessage: 'URL'
});
const TAGS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.tags', {
  defaultMessage: 'Tags'
});
const LABELS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.labels', {
  defaultMessage: 'Labels'
});
const ENABLED_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.monitorDetails.enabled', {
  defaultMessage: 'Enabled (all locations)'
});
const MONITOR_TYPE_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.monitorDetails.monitorType', {
  defaultMessage: 'Monitor type'
});
const MONITOR_DETAILS_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.monitorDetails', {
  defaultMessage: 'Monitor details'
});
const LAST_MODIFIED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.lastModified', {
  defaultMessage: 'Last modified'
});
const LAST_RUN_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.lastRunHeaderText', {
  defaultMessage: 'Last run'
});
const PROJECT_ID_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.projectIdHeaderText', {
  defaultMessage: 'Project ID'
});
const MONITOR_ID_ITEM_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorList.monitorIdItemText', {
  defaultMessage: 'Monitor ID'
});
const UN_AVAILABLE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.unAvailable', {
  defaultMessage: '(unavailable)'
});