"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterStatusButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _state = require("../../../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/filter_status_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FilterStatusButton = ({
  content,
  dataTestSubj,
  isDisabled,
  value,
  withNext
}) => {
  const statusFilter = (0, _reactRedux.useSelector)(_state.selectStatusFilter);
  const dispatch = (0, _reactRedux.useDispatch)();
  const isActive = statusFilter === value;
  let color = 'text';
  if (isActive) {
    color = value === 'up' ? 'success' : value === 'down' ? 'danger' : 'text';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": dataTestSubj,
    isToggle: true,
    isSelected: isActive,
    hasActiveFilters: isActive,
    isDisabled: isDisabled,
    onClick: () => {
      dispatch((0, _state.setStatusFilter)(statusFilter === value ? undefined : value));
    },
    withNext: withNext,
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, content);
};
exports.FilterStatusButton = FilterStatusButton;