"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsRules = void 0;
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _settings = require("../../../state/settings");
var _contexts = require("../../../contexts");
var _selectors = require("../../../state/alert_rules/selectors");
var _alert_rules = require("../../../state/alert_rules");
var _synthetics_alerts = require("../../../../../../common/constants/synthetics_alerts");
var _state = require("../../../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/hooks/use_synthetics_rules.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useSyntheticsRules = isOpen => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const defaultRules = (0, _reactRedux.useSelector)(_selectors.selectSyntheticsAlerts);
  const loading = (0, _reactRedux.useSelector)(_selectors.selectSyntheticsAlertsLoading);
  const rulesLoaded = (0, _reactRedux.useSelector)(_selectors.selectSyntheticsAlertsLoaded);
  const alertFlyoutVisible = (0, _reactRedux.useSelector)(_state.selectAlertFlyoutVisibility);
  const isNewRule = (0, _reactRedux.useSelector)(_state.selectIsNewRule);
  const {
    settings
  } = (0, _reactRedux.useSelector)(_settings.selectDynamicSettings);
  const {
    canSave
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    loaded,
    data: monitors
  } = (0, _reactRedux.useSelector)(_state.selectMonitorListState);
  const hasMonitors = loaded && monitors.absoluteTotal && monitors.absoluteTotal > 0;
  const defaultRulesEnabled = settings && ((settings === null || settings === void 0 ? void 0 : settings.defaultStatusRuleEnabled) || (settings === null || settings === void 0 ? void 0 : settings.defaultTLSRuleEnabled));
  const getOrCreateAlerts = (0, _react.useCallback)(() => {
    if (canSave) {
      dispatch(_alert_rules.enableDefaultAlertingSilentlyAction.get());
    } else {
      dispatch(_alert_rules.getDefaultAlertingAction.get());
    }
  }, [canSave, dispatch]);

  // Fetch or create default rules when popover opens
  (0, _react.useEffect)(() => {
    const shouldGetOrCreateAlerts = isOpen && hasMonitors && defaultRulesEnabled && !loading && rulesLoaded === null;
    if (shouldGetOrCreateAlerts) {
      getOrCreateAlerts();
    }
  }, [isOpen, hasMonitors, defaultRulesEnabled, loading, rulesLoaded, getOrCreateAlerts]);
  const {
    triggersActionsUi: {
      ruleTypeRegistry,
      actionTypeRegistry
    },
    ...plugins
  } = (0, _public.useKibana)().services;
  const onClose = (0, _react.useCallback)(() => dispatch((0, _state.setAlertFlyoutVisible)(null)), [dispatch]);
  const EditAlertFlyout = (0, _react.useMemo)(() => {
    // Don't render if this is a new rule flyout
    if (isNewRule || !alertFlyoutVisible) {
      return null;
    }
    const initialRule = alertFlyoutVisible === _synthetics_alerts.SYNTHETICS_TLS_RULE ? defaultRules === null || defaultRules === void 0 ? void 0 : defaultRules.tlsRule : defaultRules === null || defaultRules === void 0 ? void 0 : defaultRules.statusRule;

    // If the rule doesn't exist yet, return null (the useEffect will try to fetch/create it)
    if (!initialRule) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
      plugins: {
        ...plugins,
        ruleTypeRegistry,
        actionTypeRegistry
      },
      onCancel: onClose,
      onSubmit: onClose,
      id: initialRule.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 7
      }
    });
  }, [alertFlyoutVisible, defaultRules === null || defaultRules === void 0 ? void 0 : defaultRules.tlsRule, defaultRules === null || defaultRules === void 0 ? void 0 : defaultRules.statusRule, isNewRule, plugins, ruleTypeRegistry, actionTypeRegistry, onClose]);
  const NewRuleFlyout = (0, _react.useMemo)(() => {
    if (!isNewRule || !alertFlyoutVisible) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
      plugins: {
        ...plugins,
        ruleTypeRegistry,
        actionTypeRegistry
      },
      onCancel: onClose,
      onSubmit: onClose,
      ruleTypeId: alertFlyoutVisible,
      initialValues: {
        name: alertFlyoutVisible === _synthetics_alerts.SYNTHETICS_TLS_RULE ? _i18n.i18n.translate('xpack.synthetics.alerting.defaultRuleName.tls', {
          defaultMessage: 'Synthetics monitor TLS rule'
        }) : _i18n.i18n.translate('xpack.synthetics.alerting.defaultRuleName', {
          defaultMessage: 'Synthetics monitor status rule'
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    });
  }, [isNewRule, alertFlyoutVisible, plugins, ruleTypeRegistry, actionTypeRegistry, onClose]);
  return (0, _react.useMemo)(() => ({
    loading,
    EditAlertFlyout,
    NewRuleFlyout,
    defaultRules
  }), [EditAlertFlyout, loading, NewRuleFlyout, defaultRules]);
};
exports.useSyntheticsRules = useSyntheticsRules;