"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TlsTranslations = exports.AlertTlsCondition = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/alert_tls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertTlsCondition = ({
  ageThreshold,
  expirationThreshold,
  setAgeThreshold,
  setExpirationThreshold
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement("h3", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 11
  }
}, _i18n.i18n.translate('xpack.synthetics.rules.tls.condition.title', {
  defaultMessage: 'Condition'
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
  "aria-label": TlsTranslations.criteriaAriaLabel,
  color: "success",
  description: TlsTranslations.criteriaDescription,
  value: TlsTranslations.criteriaValue,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  "data-test-subj": "tlsExpirationThreshold",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_public.ValueExpression, {
  value: expirationThreshold,
  onChangeSelectedValue: val => {
    setExpirationThreshold(val);
  },
  description: TlsTranslations.expirationDescription,
  errors: [],
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  "data-test-subj": "tlsAgeExpirationThreshold",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_public.ValueExpression, {
  value: ageThreshold,
  onChangeSelectedValue: val => {
    setAgeThreshold(val);
  },
  description: TlsTranslations.ageDescription,
  errors: [],
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 5
  }
}));
exports.AlertTlsCondition = AlertTlsCondition;
const TlsTranslations = exports.TlsTranslations = {
  criteriaAriaLabel: _i18n.i18n.translate('xpack.synthetics.rules.tls.criteriaExpression.ariaLabel', {
    defaultMessage: 'An expression displaying the criteria for the monitors that are being watched by this alert'
  }),
  criteriaDescription: _i18n.i18n.translate('xpack.synthetics.alerts.tls.criteriaExpression.description', {
    defaultMessage: 'when',
    description: 'The context of this `when` is in the conditional sense, like "when there are three cookies, eat them all".'
  }),
  criteriaValue: _i18n.i18n.translate('xpack.synthetics.tls.criteriaExpression.value', {
    defaultMessage: 'matching monitor'
  }),
  expirationDescription: _i18n.i18n.translate('xpack.synthetics.tls.expirationExpression.description', {
    defaultMessage: 'has a certificate expiring within days: '
  }),
  ageDescription: _i18n.i18n.translate('xpack.synthetics.tls.ageExpression.description', {
    defaultMessage: 'or older than days: '
  })
};