"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processCertsResult = exports.getCertsRequestBody = exports.DEFAULT_TO = exports.DEFAULT_SORT = exports.DEFAULT_SIZE = exports.DEFAULT_FROM = exports.DEFAULT_DIRECTION = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _client_defaults = require("../constants/client_defaults");
var _es_search = require("../utils/es_search");
var _as_mutable_array = require("../utils/as_mutable_array");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var SortFields = /*#__PURE__*/function (SortFields) {
  SortFields["issuer"] = "tls.server.x509.issuer.common_name";
  SortFields["not_after"] = "tls.server.x509.not_after";
  SortFields["not_before"] = "tls.server.x509.not_before";
  SortFields["common_name"] = "tls.server.x509.subject.common_name";
  return SortFields;
}(SortFields || {});
const DEFAULT_SORT = exports.DEFAULT_SORT = 'not_after';
const DEFAULT_DIRECTION = exports.DEFAULT_DIRECTION = 'asc';
const DEFAULT_SIZE = exports.DEFAULT_SIZE = 20;
const DEFAULT_FROM = exports.DEFAULT_FROM = 'now-20m';
const DEFAULT_TO = exports.DEFAULT_TO = 'now';
function absoluteDate(relativeDate) {
  var _DateMath$parse$value, _DateMath$parse;
  return (_DateMath$parse$value = (_DateMath$parse = _datemath.default.parse(relativeDate)) === null || _DateMath$parse === void 0 ? void 0 : _DateMath$parse.valueOf()) !== null && _DateMath$parse$value !== void 0 ? _DateMath$parse$value : relativeDate;
}
const getCertsRequestBody = ({
  monitorIds,
  pageIndex,
  search,
  notValidBefore,
  notValidAfter,
  size = DEFAULT_SIZE,
  to = DEFAULT_TO,
  from = DEFAULT_FROM,
  sortBy = DEFAULT_SORT,
  direction = DEFAULT_DIRECTION,
  filters
}) => {
  const sort = SortFields[sortBy];
  return (0, _es_search.createEsQuery)({
    from: (pageIndex !== null && pageIndex !== void 0 ? pageIndex : 0) * size,
    size,
    sort: (0, _as_mutable_array.asMutableArray)([{
      [sort]: {
        order: direction
      }
    }]),
    query: {
      bool: {
        ...(search ? {
          minimum_should_match: 1,
          should: [{
            multi_match: {
              query: escape(search),
              type: 'phrase_prefix',
              fields: ['monitor.id.text', 'monitor.name.text', 'url.full.text', 'tls.server.x509.subject.common_name.text', 'tls.server.x509.issuer.common_name.text']
            }
          }]
        } : {}),
        filter: [_client_defaults.FINAL_SUMMARY_FILTER, _client_defaults.EXCLUDE_RUN_ONCE_FILTER, ...(filters ? [filters] : []), ...(monitorIds && monitorIds.length > 0 ? [{
          terms: {
            'monitor.id': monitorIds
          }
        }] : []), {
          exists: {
            field: 'tls.server.hash.sha256'
          }
        },
        // fetch large enough date range to cover the last 7 days, no particular reason for 7 days
        (0, _client_defaults.getRangeFilter)({
          from: 'now-7d',
          to: 'now'
        }), {
          range: {
            'monitor.timespan': {
              gte: absoluteDate(from),
              lte: absoluteDate(to)
            }
          }
        }, {
          bool: {
            // these notValidBefore and notValidAfter should be inside should block, since
            // we want to match either of the condition, making ir an OR operation
            minimum_should_match: 1,
            should: [...(notValidBefore ? [{
              range: {
                'tls.server.x509.not_before': {
                  lte: absoluteDate(notValidBefore)
                }
              }
            }] : []), ...(notValidAfter ? [{
              range: {
                'tls.server.x509.not_after': {
                  lte: absoluteDate(notValidAfter)
                }
              }
            }] : [])]
          }
        }]
      }
    },
    _source: ['@timestamp', 'config_id', 'monitor.id', 'monitor.name', 'monitor.type', 'url.full', 'observer.geo.name', 'agent.name', 'tls.server.x509.issuer.common_name', 'tls.server.x509.subject.common_name', 'tls.server.hash.sha1', 'tls.server.hash.sha256', 'tls.server.x509.not_after', 'tls.server.x509.not_before', 'service', 'labels', 'tags', 'error'],
    collapse: {
      field: 'tls.server.hash.sha256',
      inner_hits: {
        size: 100,
        _source: {
          includes: ['monitor.id', 'monitor.name', 'url.full', 'config_id']
        },
        collapse: {
          field: 'monitor.id'
        },
        name: 'monitors',
        sort: [{
          'monitor.id': 'asc'
        }]
      }
    },
    aggs: {
      total: {
        cardinality: {
          field: 'tls.server.hash.sha256'
        }
      }
    }
  });
};
exports.getCertsRequestBody = getCertsRequestBody;
const processCertsResult = result => {
  var _result$hits, _result$hits$hits, _result$aggregations$, _result$aggregations, _result$aggregations$2;
  const certs = (_result$hits = result.hits) === null || _result$hits === void 0 ? void 0 : (_result$hits$hits = _result$hits.hits) === null || _result$hits$hits === void 0 ? void 0 : _result$hits$hits.map(hit => {
    var _ping$tls, _server$x, _server$x2, _server$x3, _server$x3$issuer, _server$x4, _server$x4$subject, _server$hash, _server$hash2, _ping$service, _ping$url, _ping$monitor, _ping$agent, _ping$observer, _ping$observer$geo, _ping$error, _ping$error2;
    const ping = hit._source;
    const server = (_ping$tls = ping.tls) === null || _ping$tls === void 0 ? void 0 : _ping$tls.server;
    const notAfter = server === null || server === void 0 ? void 0 : (_server$x = server.x509) === null || _server$x === void 0 ? void 0 : _server$x.not_after;
    const notBefore = server === null || server === void 0 ? void 0 : (_server$x2 = server.x509) === null || _server$x2 === void 0 ? void 0 : _server$x2.not_before;
    const issuer = server === null || server === void 0 ? void 0 : (_server$x3 = server.x509) === null || _server$x3 === void 0 ? void 0 : (_server$x3$issuer = _server$x3.issuer) === null || _server$x3$issuer === void 0 ? void 0 : _server$x3$issuer.common_name;
    const commonName = server === null || server === void 0 ? void 0 : (_server$x4 = server.x509) === null || _server$x4 === void 0 ? void 0 : (_server$x4$subject = _server$x4.subject) === null || _server$x4$subject === void 0 ? void 0 : _server$x4$subject.common_name;
    const sha1 = server === null || server === void 0 ? void 0 : (_server$hash = server.hash) === null || _server$hash === void 0 ? void 0 : _server$hash.sha1;
    const sha256 = server === null || server === void 0 ? void 0 : (_server$hash2 = server.hash) === null || _server$hash2 === void 0 ? void 0 : _server$hash2.sha256;
    const monitors = hit.inner_hits.monitors.hits.hits.map(monitor => {
      var _monitorPing$url;
      const monitorPing = monitor._source;
      return {
        name: monitorPing === null || monitorPing === void 0 ? void 0 : monitorPing.monitor.name,
        id: monitorPing === null || monitorPing === void 0 ? void 0 : monitorPing.monitor.id,
        configId: monitorPing === null || monitorPing === void 0 ? void 0 : monitorPing.config_id,
        url: monitorPing === null || monitorPing === void 0 ? void 0 : (_monitorPing$url = monitorPing.url) === null || _monitorPing$url === void 0 ? void 0 : _monitorPing$url.full
      };
    });
    return {
      monitors,
      issuer,
      sha1,
      sha256: sha256,
      not_after: notAfter,
      not_before: notBefore,
      common_name: commonName,
      monitorName: ping.monitor.name,
      monitorId: ping.monitor.id,
      serviceName: ping === null || ping === void 0 ? void 0 : (_ping$service = ping.service) === null || _ping$service === void 0 ? void 0 : _ping$service.name,
      configId: ping.config_id,
      monitorUrl: ping === null || ping === void 0 ? void 0 : (_ping$url = ping.url) === null || _ping$url === void 0 ? void 0 : _ping$url.full,
      labels: ping === null || ping === void 0 ? void 0 : ping.labels,
      tags: ping === null || ping === void 0 ? void 0 : ping.tags,
      '@timestamp': ping['@timestamp'],
      monitorType: ping === null || ping === void 0 ? void 0 : (_ping$monitor = ping.monitor) === null || _ping$monitor === void 0 ? void 0 : _ping$monitor.type,
      locationId: ping.observer.name,
      hostName: ping === null || ping === void 0 ? void 0 : (_ping$agent = ping.agent) === null || _ping$agent === void 0 ? void 0 : _ping$agent.name,
      locationName: ping === null || ping === void 0 ? void 0 : (_ping$observer = ping.observer) === null || _ping$observer === void 0 ? void 0 : (_ping$observer$geo = _ping$observer.geo) === null || _ping$observer$geo === void 0 ? void 0 : _ping$observer$geo.name,
      errorMessage: ping === null || ping === void 0 ? void 0 : (_ping$error = ping.error) === null || _ping$error === void 0 ? void 0 : _ping$error.message,
      errorStackTrace: ping === null || ping === void 0 ? void 0 : (_ping$error2 = ping.error) === null || _ping$error2 === void 0 ? void 0 : _ping$error2.stack_trace
    };
  });
  const total = (_result$aggregations$ = (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : (_result$aggregations$2 = _result$aggregations.total) === null || _result$aggregations$2 === void 0 ? void 0 : _result$aggregations$2.value) !== null && _result$aggregations$ !== void 0 ? _result$aggregations$ : 0;
  return {
    certs,
    total
  };
};
exports.processCertsResult = processCertsResult;