"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.failureStoreStatsSchema = exports.failureStoreSchema = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const failureStoreSchema = exports.failureStoreSchema = _zod.z.object({
  enabled: _zod.z.boolean(),
  retentionPeriod: _zod.z.object({
    default: _zodHelpers.NonEmptyString,
    custom: _zod.z.optional(_zodHelpers.NonEmptyString)
  })
});
const failureStoreStatsSchema = exports.failureStoreStatsSchema = _zod.z.object({
  size: _zod.z.number().min(0).optional(),
  count: _zod.z.number().min(0).optional(),
  creationDate: _zod.z.number().min(0).optional()
});