"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  Streams: true,
  IngestBase: true,
  Ingest: true,
  WiredIngest: true,
  ClassicIngest: true,
  Group: true,
  routingStatus: true,
  isRoutingEnabled: true,
  routingDefinitionListSchema: true,
  isRootStreamDefinition: true,
  getIndexPatternsForStream: true,
  keepFields: true,
  namespacePrefixes: true,
  isNamespacedEcsField: true,
  getRegularEcsField: true,
  getAdvancedParameters: true,
  getInheritedFieldsFromAncestors: true,
  getInheritedSettings: true,
  buildEsqlQuery: true,
  flattenRecord: true,
  recursiveRecord: true,
  isSchema: true,
  createIsNarrowSchema: true,
  isChildOf: true,
  isDescendantOf: true,
  getAncestors: true,
  getAncestorsAndSelf: true,
  getParentId: true,
  getSegments: true,
  MAX_NESTING_LEVEL: true,
  isRoot: true,
  fieldDefinitionConfigSchema: true,
  namedFieldDefinitionConfigSchema: true,
  upsertStreamQueryRequestSchema: true,
  streamQueryKqlSchema: true,
  streamQuerySchema: true,
  findInheritedLifecycle: true,
  findInheritingStreams: true,
  effectiveToIngestLifecycle: true,
  streamObjectNameSchema: true,
  isDslLifecycle: true,
  isIlmLifecycle: true,
  isInheritLifecycle: true,
  isErrorLifecycle: true,
  isDisabledLifecycle: true,
  emptyAssets: true,
  featureSchema: true
};
Object.defineProperty(exports, "ClassicIngest", {
  enumerable: true,
  get: function () {
    return _classic.ClassicIngest;
  }
});
Object.defineProperty(exports, "Group", {
  enumerable: true,
  get: function () {
    return _group.Group;
  }
});
Object.defineProperty(exports, "Ingest", {
  enumerable: true,
  get: function () {
    return _ingest.Ingest;
  }
});
Object.defineProperty(exports, "IngestBase", {
  enumerable: true,
  get: function () {
    return _base.IngestBase;
  }
});
Object.defineProperty(exports, "MAX_NESTING_LEVEL", {
  enumerable: true,
  get: function () {
    return _hierarchy.MAX_NESTING_LEVEL;
  }
});
Object.defineProperty(exports, "Streams", {
  enumerable: true,
  get: function () {
    return _streams.Streams;
  }
});
Object.defineProperty(exports, "WiredIngest", {
  enumerable: true,
  get: function () {
    return _wired.WiredIngest;
  }
});
Object.defineProperty(exports, "buildEsqlQuery", {
  enumerable: true,
  get: function () {
    return _query.buildEsqlQuery;
  }
});
Object.defineProperty(exports, "createIsNarrowSchema", {
  enumerable: true,
  get: function () {
    return _type_guards.createIsNarrowSchema;
  }
});
Object.defineProperty(exports, "effectiveToIngestLifecycle", {
  enumerable: true,
  get: function () {
    return _lifecycle.effectiveToIngestLifecycle;
  }
});
Object.defineProperty(exports, "emptyAssets", {
  enumerable: true,
  get: function () {
    return _empty_assets.emptyAssets;
  }
});
Object.defineProperty(exports, "featureSchema", {
  enumerable: true,
  get: function () {
    return _feature.featureSchema;
  }
});
Object.defineProperty(exports, "fieldDefinitionConfigSchema", {
  enumerable: true,
  get: function () {
    return _fields.fieldDefinitionConfigSchema;
  }
});
Object.defineProperty(exports, "findInheritedLifecycle", {
  enumerable: true,
  get: function () {
    return _lifecycle.findInheritedLifecycle;
  }
});
Object.defineProperty(exports, "findInheritingStreams", {
  enumerable: true,
  get: function () {
    return _lifecycle.findInheritingStreams;
  }
});
Object.defineProperty(exports, "flattenRecord", {
  enumerable: true,
  get: function () {
    return _record_types.flattenRecord;
  }
});
Object.defineProperty(exports, "getAdvancedParameters", {
  enumerable: true,
  get: function () {
    return _get_advanced_parameters.getAdvancedParameters;
  }
});
Object.defineProperty(exports, "getAncestors", {
  enumerable: true,
  get: function () {
    return _hierarchy.getAncestors;
  }
});
Object.defineProperty(exports, "getAncestorsAndSelf", {
  enumerable: true,
  get: function () {
    return _hierarchy.getAncestorsAndSelf;
  }
});
Object.defineProperty(exports, "getIndexPatternsForStream", {
  enumerable: true,
  get: function () {
    return _hierarchy_helpers.getIndexPatternsForStream;
  }
});
Object.defineProperty(exports, "getInheritedFieldsFromAncestors", {
  enumerable: true,
  get: function () {
    return _get_inherited_fields_from_ancestors.getInheritedFieldsFromAncestors;
  }
});
Object.defineProperty(exports, "getInheritedSettings", {
  enumerable: true,
  get: function () {
    return _get_inherited_settings.getInheritedSettings;
  }
});
Object.defineProperty(exports, "getParentId", {
  enumerable: true,
  get: function () {
    return _hierarchy.getParentId;
  }
});
Object.defineProperty(exports, "getRegularEcsField", {
  enumerable: true,
  get: function () {
    return _namespaced_ecs.getRegularEcsField;
  }
});
Object.defineProperty(exports, "getSegments", {
  enumerable: true,
  get: function () {
    return _hierarchy.getSegments;
  }
});
Object.defineProperty(exports, "isChildOf", {
  enumerable: true,
  get: function () {
    return _hierarchy.isChildOf;
  }
});
Object.defineProperty(exports, "isDescendantOf", {
  enumerable: true,
  get: function () {
    return _hierarchy.isDescendantOf;
  }
});
Object.defineProperty(exports, "isDisabledLifecycle", {
  enumerable: true,
  get: function () {
    return _lifecycle2.isDisabledLifecycle;
  }
});
Object.defineProperty(exports, "isDslLifecycle", {
  enumerable: true,
  get: function () {
    return _lifecycle2.isDslLifecycle;
  }
});
Object.defineProperty(exports, "isErrorLifecycle", {
  enumerable: true,
  get: function () {
    return _lifecycle2.isErrorLifecycle;
  }
});
Object.defineProperty(exports, "isIlmLifecycle", {
  enumerable: true,
  get: function () {
    return _lifecycle2.isIlmLifecycle;
  }
});
Object.defineProperty(exports, "isInheritLifecycle", {
  enumerable: true,
  get: function () {
    return _lifecycle2.isInheritLifecycle;
  }
});
Object.defineProperty(exports, "isNamespacedEcsField", {
  enumerable: true,
  get: function () {
    return _namespaced_ecs.isNamespacedEcsField;
  }
});
Object.defineProperty(exports, "isRoot", {
  enumerable: true,
  get: function () {
    return _hierarchy.isRoot;
  }
});
Object.defineProperty(exports, "isRootStreamDefinition", {
  enumerable: true,
  get: function () {
    return _is_root.isRootStreamDefinition;
  }
});
Object.defineProperty(exports, "isRoutingEnabled", {
  enumerable: true,
  get: function () {
    return _routing.isRoutingEnabled;
  }
});
Object.defineProperty(exports, "isSchema", {
  enumerable: true,
  get: function () {
    return _type_guards.isSchema;
  }
});
Object.defineProperty(exports, "keepFields", {
  enumerable: true,
  get: function () {
    return _namespaced_ecs.keepFields;
  }
});
Object.defineProperty(exports, "namedFieldDefinitionConfigSchema", {
  enumerable: true,
  get: function () {
    return _fields.namedFieldDefinitionConfigSchema;
  }
});
Object.defineProperty(exports, "namespacePrefixes", {
  enumerable: true,
  get: function () {
    return _namespaced_ecs.namespacePrefixes;
  }
});
Object.defineProperty(exports, "recursiveRecord", {
  enumerable: true,
  get: function () {
    return _record_types.recursiveRecord;
  }
});
Object.defineProperty(exports, "routingDefinitionListSchema", {
  enumerable: true,
  get: function () {
    return _routing.routingDefinitionListSchema;
  }
});
Object.defineProperty(exports, "routingStatus", {
  enumerable: true,
  get: function () {
    return _routing.routingStatus;
  }
});
Object.defineProperty(exports, "streamObjectNameSchema", {
  enumerable: true,
  get: function () {
    return _stream_object_name.streamObjectNameSchema;
  }
});
Object.defineProperty(exports, "streamQueryKqlSchema", {
  enumerable: true,
  get: function () {
    return _queries.streamQueryKqlSchema;
  }
});
Object.defineProperty(exports, "streamQuerySchema", {
  enumerable: true,
  get: function () {
    return _queries.streamQuerySchema;
  }
});
Object.defineProperty(exports, "upsertStreamQueryRequestSchema", {
  enumerable: true,
  get: function () {
    return _queries.upsertStreamQueryRequestSchema;
  }
});
var _streams = require("./src/models/streams");
var _base = require("./src/models/ingest/base");
var _ingest = require("./src/models/ingest");
var _wired = require("./src/models/ingest/wired");
var _classic = require("./src/models/ingest/classic");
var _group = require("./src/models/group");
var _routing = require("./src/models/ingest/routing");
var _is_root = require("./src/helpers/is_root");
var _hierarchy_helpers = require("./src/helpers/hierarchy_helpers");
var _namespaced_ecs = require("./src/helpers/namespaced_ecs");
var _get_advanced_parameters = require("./src/helpers/get_advanced_parameters");
var _get_inherited_fields_from_ancestors = require("./src/helpers/get_inherited_fields_from_ancestors");
var _get_inherited_settings = require("./src/helpers/get_inherited_settings");
var _query = require("./src/helpers/query");
var _ingest_pipeline_processors = require("./src/ingest_pipeline_processors");
Object.keys(_ingest_pipeline_processors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _ingest_pipeline_processors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _ingest_pipeline_processors[key];
    }
  });
});
var _record_types = require("./src/shared/record_types");
var _type_guards = require("./src/shared/type_guards");
var _hierarchy = require("./src/shared/hierarchy");
var _fields = require("./src/fields");
var _queries = require("./src/queries");
var _lifecycle = require("./src/helpers/lifecycle");
var _stream_object_name = require("./src/shared/stream_object_name");
var _lifecycle2 = require("./src/models/ingest/lifecycle");
var _empty_assets = require("./src/helpers/empty_assets");
var _feature = require("./src/feature");