"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogPatterns = getLogPatterns;
var _aiTools = require("@kbn/ai-tools");
var _streamsSchema = require("@kbn/streams-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLogPatterns(params, dependencies) {
  const {
    esClient,
    logger
  } = dependencies;
  const {
    categorizationField,
    lookbackStart,
    end,
    definition
  } = params;
  if (!categorizationField) {
    logger.debug('No categorization field found, skipping log pattern analysis');
    return undefined;
  }
  const logPatterns = await (0, _aiTools.getLogPatterns)({
    start: lookbackStart,
    end,
    esClient,
    fields: [categorizationField],
    index: (0, _streamsSchema.getIndexPatternsForStream)(definition),
    includeChanges: true,
    metadata: []
  }).then(results => {
    return results.map(result => {
      const {
        sample,
        count,
        regex
      } = result;
      return {
        count,
        sample,
        regex
      };
    });
  });
  if (logPatterns !== null && logPatterns !== void 0 && logPatterns.length) {
    logger.debug(() => {
      return `Found ${logPatterns === null || logPatterns === void 0 ? void 0 : logPatterns.length} log patterns: ${logPatterns.map(pattern => `- ${pattern.sample} (${pattern.count})`).join('\n')}
      `;
    });
  }
  return logPatterns;
}