"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvalidContentPackError = exports.ContentPackIncludeError = exports.ContentPackConflictError = void 0;
var _status_error = require("../streams/errors/status_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */

class InvalidContentPackError extends _status_error.StatusError {
  constructor(message) {
    super(message, 400);
    this.name = 'InvalidContentPackError';
  }
}
exports.InvalidContentPackError = InvalidContentPackError;
class ContentPackConflictError extends _status_error.StatusError {
  constructor(message) {
    super(message, 409);
    this.name = 'ContentPackConflictError';
  }
}
exports.ContentPackConflictError = ContentPackConflictError;
class ContentPackIncludeError extends _status_error.StatusError {
  constructor(message) {
    super(message, 400);
    this.name = 'ContentPackIncludeError';
  }
}
exports.ContentPackIncludeError = ContentPackIncludeError;