"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetQualityController = void 0;
var _react = require("react");
var _streamsSchema = require("@kbn/streams-schema");
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/dataset-quality-plugin/common");
var _url_state_storage_service = require("../util/url_state_storage_service");
var _use_kibana = require("./use_kibana");
var _use_timefilter = require("./use_timefilter");
var _kbn_url_state_context = require("../util/kbn_url_state_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatasetQualityController = (definition, saveStateInUrl = true) => {
  const {
    datasetQuality
  } = (0, _use_kibana.useKibana)().dependencies.start;
  const {
    core: {
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const [controller, setController] = (0, _react.useState)();
  const urlStateStorageContainer = (0, _kbn_url_state_context.useKbnUrlStateStorageFromRouterContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    timeState,
    setTime
  } = (0, _use_timefilter.useTimefilter)();
  (0, _react.useEffect)(() => {
    async function getDatasetQualityDetailsController() {
      let initialState = (0, _url_state_storage_service.getDatasetQualityDetailsStateFromUrl)({
        urlStateStorageContainer,
        toastsService: toasts
      });

      // state initialization is under progress
      if (initialState === undefined) {
        return;
      }

      // state initialized but empty
      if (initialState === null) {
        initialState = {
          dataStream: definition.stream.name,
          view: _streamsSchema.Streams.WiredStream.Definition.is(definition.stream) ? 'wired' : 'classic',
          timeRange: {
            from: timeState.timeRange.from,
            to: timeState.timeRange.to,
            refresh: _common.DEFAULT_DATEPICKER_REFRESH
          }
        };
      }
      const datasetQualityDetailsController = await datasetQuality.createDatasetQualityDetailsController({
        initialState: {
          ...initialState,
          view: _streamsSchema.Streams.WiredStream.Definition.is(definition.stream) ? 'wired' : 'classic'
        }
      });
      datasetQualityDetailsController.service.start();
      setController(datasetQualityDetailsController);
      if (!saveStateInUrl) {
        return () => {
          datasetQualityDetailsController.service.stop();
        };
      }
      const datasetQualityStateSubscription = datasetQualityDetailsController.state$.subscribe(state => {
        (0, _url_state_storage_service.updateUrlFromDatasetQualityDetailsState)({
          urlStateStorageContainer,
          datasetQualityDetailsState: state,
          setTime
        });
      });
      return () => {
        datasetQualityDetailsController.service.stop();
        datasetQualityStateSubscription.unsubscribe();
      };
    }
    getDatasetQualityDetailsController();
  }, [datasetQuality, history, toasts, urlStateStorageContainer, definition.stream.name, saveStateInUrl, definition.stream, timeState.timeRange.from, timeState.timeRange.to, setTime]);
  return controller;
};
exports.useDatasetQualityController = useDatasetQualityController;