"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsAppSearchBar = StreamsAppSearchBar;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _common = require("@kbn/data-plugin/common");
var _uncontrolled_streams_app_bar = require("./uncontrolled_streams_app_bar");
var _use_timefilter = require("../../hooks/use_timefilter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/streams_app_search_bar/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// If the absolute time stays the same
function needsRefresh(left, right) {
  const forceNow = new Date();
  const leftAbsolute = (0, _common.getAbsoluteTimeRange)(left, {
    forceNow
  });
  const rightAbsolute = (0, _common.getAbsoluteTimeRange)(right, {
    forceNow
  });
  return (0, _lodash.isEqual)(leftAbsolute, rightAbsolute);
}
function StreamsAppSearchBar({
  onQuerySubmit,
  ...props
}) {
  const {
    timeState,
    setTime,
    refresh
  } = (0, _use_timefilter.useTimefilter)();
  function refreshOrSetTime(next) {
    if (needsRefresh(timeState.timeRange, next)) {
      refresh();
    } else {
      setTime(next);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_uncontrolled_streams_app_bar.UncontrolledStreamsAppSearchBar, (0, _extends2.default)({
    onQuerySubmit: ({
      dateRange,
      query
    }, isUpdate) => {
      if (dateRange) {
        refreshOrSetTime(dateRange);
      }
      onQuerySubmit === null || onQuerySubmit === void 0 ? void 0 : onQuerySubmit({
        dateRange,
        query
      }, isUpdate);
    },
    dateRangeFrom: timeState.timeRange.from,
    dateRangeTo: timeState.timeRange.to
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }));
}