"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamNotFoundPrompt = StreamNotFoundPrompt;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _streams_app_page_template = require("../streams_app_page_template");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_not_found_prompt/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function StreamNotFoundPrompt({
  streamName
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  return /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.EmptyPrompt, {
    "data-test-subj": "streamNotFoundPrompt",
    iconType: "search",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamNotFound.description",
      defaultMessage: "The stream {streamName} does not exist.",
      values: {
        streamName
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 11
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "streamNotFoundBackButton",
      fill: true,
      href: router.link('/'),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamNotFound.backButton', {
      defaultMessage: 'Back to Streams'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
}