"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsTreeTable = StreamsTreeTable;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _streamsSchema = require("@kbn/streams-schema");
var _utils = require("./utils");
var _streams_app_search_bar = require("../streams_app_search_bar");
var _documents_column = require("./documents_column");
var _data_quality_column = require("./data_quality_column");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _use_streams_doc_counts_fetch = require("../../hooks/use_streams_doc_counts_fetch");
var _use_timefilter = require("../../hooks/use_timefilter");
var _retention_column = require("./retention_column");
var _translations = require("./translations");
var _stream_badges = require("../stream_badges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_list_view/tree_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const datePickerStyle = (0, _css.css)`
  .euiFormControlLayout,
  .euiSuperDatePicker button,
  .euiButton {
    height: 40px;
  }
`;
function StreamsTreeTable({
  loading,
  streams = [],
  canReadFailureStore = false
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const [sortField, setSortField] = (0, _react.useState)('nameSortKey');
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  // Collapsed state: Set of collapsed node names
  const [collapsed, setCollapsed] = (0, _react.useState)(new Set());
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: 25
  });

  // Filter streams by query, including ancestors of matches
  const filteredStreams = _react.default.useMemo(() => (0, _utils.filterStreamsByQuery)(streams.filter(stream => _streamsSchema.Streams.ingest.all.Definition.is(stream.stream)), searchQuery), [streams, searchQuery]);
  const enrichedStreams = _react.default.useMemo(() => {
    const streamList = (0, _utils.shouldComposeTree)(sortField) ? (0, _utils.asTrees)(filteredStreams) : filteredStreams;
    return streamList.map(_utils.enrichStream);
  }, [sortField, filteredStreams]);
  const flattenTreeWithCollapse = _react.default.useCallback(rows => (0, _utils.filterCollapsedStreamRows)(rows, collapsed, sortField), [collapsed, sortField]);
  const allRows = _react.default.useMemo(() => (0, _utils.buildStreamRows)(enrichedStreams, sortField, sortDirection), [enrichedStreams, sortField, sortDirection]);

  // Only pass filtered rows if tree mode is active
  const items = _react.default.useMemo(() => (0, _utils.shouldComposeTree)(sortField) ? flattenTreeWithCollapse(allRows) : allRows, [allRows, flattenTreeWithCollapse, sortField]);
  const handleQueryChange = ({
    query
  }) => {
    if (query) setSearchQuery(query.text);
  };
  const handleTableChange = ({
    sort,
    page
  }) => {
    if (sort) {
      setSortField(sort.field);
      setSortDirection(sort.direction);
    }
    if (page) {
      setPagination({
        pageIndex: page.index,
        pageSize: page.size
      });
    }
  };
  const handleToggleCollapse = name => {
    setCollapsed(prev => {
      const next = new Set(prev);
      if (next.has(name)) {
        next.delete(name);
      } else {
        next.add(name);
      }
      return next;
    });
  };

  // Compute all expandable node names for expand/collapse all
  const allExpandableNodeNames = _react.default.useMemo(() => {
    const names = [];
    const collect = rows => {
      for (const row of rows) {
        if (row.children && row.children.length > 0) {
          names.push(row.stream.name);
        }
      }
    };
    collect(allRows);
    return names;
  }, [allRows]);

  // Determine if all are expanded or not
  const allExpanded = allExpandableNodeNames.every(name => !collapsed.has(name));
  const hasExpandable = allExpandableNodeNames.length > 0;
  const handleExpandCollapseAll = () => {
    setCollapsed(prev => {
      if (allExpanded) {
        // Collapse all
        return new Set(allExpandableNodeNames);
      } else {
        // Expand all
        return new Set();
      }
    });
  };
  const numDataPoints = 25;
  const {
    getStreamDocCounts
  } = (0, _use_streams_doc_counts_fetch.useStreamDocCountsFetch)({
    groupTotalCountByTimestamp: true,
    numDataPoints,
    canReadFailureStore
  });
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };

  // Reset pagination if streams change (e.g., after search/filter)
  _react.default.useEffect(() => {
    setPagination(prev => ({
      ...prev,
      pageIndex: 0
    }));
  }, [streams, searchQuery, sortField, sortDirection]);

  // Expand/Collapse all button for the name column header
  const expandCollapseAllButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: allExpanded ? 'fold' : 'unfold',
    color: "text",
    onClick: e => {
      e.stopPropagation();
      handleExpandCollapseAll();
    },
    "data-test-subj": `streams${allExpanded ? 'Collapse' : 'Expand'}AllButton`,
    "aria-label": allExpanded ? _i18n.i18n.translate('xpack.streams.streamsTreeTable.collapseAll', {
      defaultMessage: 'Collapse all'
    }) : _i18n.i18n.translate('xpack.streams.streamsTreeTable.expandAll', {
      defaultMessage: 'Expand all'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: loading,
    "data-test-subj": "streamsTable",
    columns: [{
      field: 'nameSortKey',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        responsive: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 13
        }
      }, (0, _utils.shouldComposeTree)(sortField) && hasExpandable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 227,
          columnNumber: 17
        }
      }, expandCollapseAllButton), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 15
        }
      }, _translations.NAME_COLUMN_HEADER)),
      sortable: row => row.rootNameSortKey,
      dataType: 'string',
      render: (_, item) => {
        // Only show expand/collapse if tree mode is active and has children
        const treeMode = (0, _utils.shouldComposeTree)(sortField);
        const hasChildren = !!item.children && item.children.length > 0;
        const isCollapsed = collapsed.has(item.stream.name);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "s",
          responsive: false,
          className: (0, _css.css)`
                  margin-left: ${item.level * parseInt(euiTheme.size.xl, 10)}px;
                `,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 240,
            columnNumber: 15
          }
        }, treeMode && item.children && hasChildren && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 249,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: isCollapsed ? 'arrowRight' : 'arrowDown',
          color: "text",
          size: "m",
          "data-test-subj": `${isCollapsed ? 'expand' : 'collapse'}Button-${item.stream.name}`,
          "aria-label": _i18n.i18n.translate(isCollapsed ? 'xpack.streams.streamsTreeTable.collapsedNodeAriaLabel' : 'xpack.streams.streamsTreeTable.expandedNodeAriaLabel', {
            defaultMessage: isCollapsed ? 'Collapsed node with {childCount} children' : 'Expanded node with {childCount} children',
            values: {
              childCount: item.children.length
            }
          }),
          onClick: e => {
            handleToggleCollapse(item.stream.name);
          },
          tabIndex: 0,
          role: "button",
          onKeyDown: e => {
            if (e.key === 'Enter' || e.key === ' ') {
              e.preventDefault();
              handleToggleCollapse(item.stream.name);
            }
          },
          style: {
            cursor: 'pointer'
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 250,
            columnNumber: 21
          }
        })), treeMode && !hasChildren && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 284,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "empty",
          color: "text",
          size: "m",
          "aria-hidden": "true",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 285,
            columnNumber: 21
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 288,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": `streamsNameLink-${item.stream.name}`,
          href: router.link('/{key}', {
            path: {
              key: item.stream.name
            }
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 289,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
          search: searchQuery,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 293,
            columnNumber: 21
          }
        }, item.stream.name))));
      }
    }, {
      field: 'documentsCount',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 303,
          columnNumber: 13
        }
      }, _translations.DOCUMENTS_COLUMN_HEADER, !canReadFailureStore && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _translations.FAILURE_STORE_PERMISSIONS_ERROR,
        type: "warning",
        color: "warning",
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 17
        }
      })),
      width: '180px',
      sortable: false,
      align: 'right',
      dataType: 'number',
      render: (_, item) => item.data_stream ? /*#__PURE__*/_react.default.createElement(_documents_column.DocumentsColumn, {
        indexPattern: item.stream.name,
        histogramQueryFetch: getStreamDocCounts(item.stream.name),
        timeState: timeState,
        numDataPoints: numDataPoints,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 321,
          columnNumber: 15
        }
      }) : null
    }, {
      field: 'dataQuality',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 332,
          columnNumber: 13
        }
      }, _translations.DATA_QUALITY_COLUMN_HEADER, !canReadFailureStore && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _translations.FAILURE_STORE_PERMISSIONS_ERROR,
        type: "warning",
        color: "warning",
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 335,
          columnNumber: 17
        }
      })),
      width: '150px',
      sortable: false,
      dataType: 'number',
      render: (_, item) => item.data_stream ? /*#__PURE__*/_react.default.createElement(_data_quality_column.DataQualityColumn, {
        histogramQueryFetch: getStreamDocCounts(item.stream.name),
        streamName: item.stream.name,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 349,
          columnNumber: 15
        }
      }) : null
    }, {
      field: 'retentionMs',
      name: /*#__PURE__*/_react.default.createElement("span", {
        "aria-label": _translations.RETENTION_COLUMN_HEADER_ARIA_LABEL,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 358,
          columnNumber: 13
        }
      }, _translations.RETENTION_COLUMN_HEADER),
      align: 'left',
      sortable: row => row.rootRetentionMs,
      dataType: 'number',
      width: '220px',
      render: (_, item) => /*#__PURE__*/_react.default.createElement(_retention_column.RetentionColumn, {
        lifecycle: item.effective_lifecycle,
        "aria-label": _i18n.i18n.translate('xpack.streams.streamsTreeTable.retentionCellAriaLabel', {
          defaultMessage: 'Retention policy for {name}',
          values: {
            name: item.stream.name
          }
        }),
        dataTestSubj: `retentionColumn-${item.stream.name}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 365,
          columnNumber: 13
        }
      })
    }, {
      field: 'definition',
      name: 'Actions',
      width: '60px',
      align: 'left',
      sortable: false,
      dataType: 'string',
      render: (_, item) => /*#__PURE__*/_react.default.createElement(_stream_badges.DiscoverBadgeButton, {
        definition: {
          stream: item.stream,
          data_stream_exists: !!item.data_stream
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 383,
          columnNumber: 13
        }
      })
    }],
    itemId: "name",
    items: items,
    sorting: sorting,
    noItemsMessage: _translations.NO_STREAMS_MESSAGE,
    onTableChange: handleTableChange,
    pagination: {
      initialPageSize: 25,
      pageSizeOptions: [25, 50, 100],
      pageIndex: pagination.pageIndex,
      pageSize: pagination.pageSize
    },
    executeQueryOptions: {
      enabled: false
    },
    search: {
      query: searchQuery,
      onChange: handleQueryChange,
      box: {
        incremental: true,
        'aria-label': _translations.STREAMS_TABLE_SEARCH_ARIA_LABEL
      },
      toolsRight: /*#__PURE__*/_react.default.createElement("div", {
        className: datePickerStyle,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 414,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_streams_app_search_bar.StreamsAppSearchBar, {
        showDatePicker: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 415,
          columnNumber: 13
        }
      }))
    },
    tableCaption: _translations.STREAMS_TABLE_CAPTION_ARIA_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 5
    }
  });
}