"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamListView = StreamListView;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _lodash = require("lodash");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_kibana = require("../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../hooks/use_streams_app_fetch");
var _tree_table = require("./tree_table");
var _streams_app_page_template = require("../streams_app_page_template");
var _streams_list_empty_prompt = require("./streams_list_empty_prompt");
var _use_timefilter = require("../../hooks/use_timefilter");
var _group_stream_modification_flyout = require("../group_stream_modification_flyout/group_stream_modification_flyout");
var _group_streams_cards = require("./group_streams_cards");
var _use_streams_privileges = require("../../hooks/use_streams_privileges");
var _streams_app_context_provider = require("../streams_app_context_provider");
var _streams_settings_flyout = require("./streams_settings_flyout");
var _feedback_button = require("../feedback_button");
var _asset_image = require("../asset_image");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_list_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function StreamListView() {
  var _streamsListFetch$val2, _streamsListFetch$val3, _streamsListFetch$val4, _streamsListFetch$val5;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const context = (0, _use_kibana.useKibana)();
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    },
    core,
    isServerless
  } = context;
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const streamsListFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => streamsRepositoryClient.fetch('GET /internal/streams', {
    signal
  }),
  // time state change is used to trigger a refresh of the listed
  // streams metadata but we operate on stale data if we don't
  // also refresh the streams
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [streamsRepositoryClient, timeState.start, timeState.end]);
  const {
    features: {
      groupStreams
    }
  } = (0, _use_streams_privileges.useStreamsPrivileges)();

  // Always show settings flyout button if not serverless
  const showSettingsFlyoutButton = isServerless === false;
  const overlayRef = _react.default.useRef(null);
  const [isSettingsFlyoutOpen, setIsSettingsFlyoutOpen] = _react.default.useState(false);
  function openGroupStreamModificationFlyout() {
    var _overlayRef$current, _streamsListFetch$val;
    (_overlayRef$current = overlayRef.current) === null || _overlayRef$current === void 0 ? void 0 : _overlayRef$current.close();
    overlayRef.current = core.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_streams_app_context_provider.StreamsAppContextProvider, {
      context: context,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_group_stream_modification_flyout.GroupStreamModificationFlyout, {
      client: streamsRepositoryClient,
      streamsList: (_streamsListFetch$val = streamsListFetch.value) === null || _streamsListFetch$val === void 0 ? void 0 : _streamsListFetch$val.streams,
      refresh: () => {
        var _overlayRef$current2;
        streamsListFetch.refresh();
        (_overlayRef$current2 = overlayRef.current) === null || _overlayRef$current2 === void 0 ? void 0 : _overlayRef$current2.close();
      },
      notifications: core.notifications,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    })), core), {
      size: 's'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Header, {
    bottomBorder: "extended",
    css: (0, _react2.css)`
          background: ${euiTheme.colors.backgroundBasePlain};
        `,
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      gutterSize: "s",
      responsive: false,
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.streamsListView.pageHeaderTitle', {
      defaultMessage: 'Streams'
    }), isServerless && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _i18n.i18n.translate('xpack.streams.streamsListView.betaBadgeLabel', {
        defaultMessage: 'Technical Preview'
      }),
      tooltipContent: _i18n.i18n.translate('xpack.streams.streamsListView.betaBadgeDescription', {
        defaultMessage: 'This functionality is experimental and not supported. It may change or be removed at any time.'
      }),
      alignment: "middle",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 19
      }
    }))), (groupStreams === null || groupStreams === void 0 ? void 0 : groupStreams.enabled) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: openGroupStreamModificationFlyout,
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.streams.streamsListView.createGroupStreamButtonLabel', {
      defaultMessage: 'Create Group stream'
    }))), showSettingsFlyoutButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "gear",
      size: "s",
      onClick: () => setIsSettingsFlyoutOpen(true),
      "aria-label": _i18n.i18n.translate('xpack.streams.streamsListView.settingsButtonLabel', {
        defaultMessage: 'Settings'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.streams.streamsListView.settingsButtonLabel', {
      defaultMessage: 'Settings'
    }))), /*#__PURE__*/_react.default.createElement(_feedback_button.FeedbackButton, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Body, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, streamsListFetch.loading && streamsListFetch.value === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 19
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.streamsListView.loadingStreams', {
      defaultMessage: 'Loading Streams'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }) : !streamsListFetch.loading && (0, _lodash.isEmpty)((_streamsListFetch$val2 = streamsListFetch.value) === null || _streamsListFetch$val2 === void 0 ? void 0 : _streamsListFetch$val2.streams) ? /*#__PURE__*/_react.default.createElement(_streams_list_empty_prompt.StreamsListEmptyPrompt, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(WelcomePanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_tree_table.StreamsTreeTable, {
    loading: streamsListFetch.loading,
    streams: (_streamsListFetch$val3 = streamsListFetch.value) === null || _streamsListFetch$val3 === void 0 ? void 0 : _streamsListFetch$val3.streams,
    canReadFailureStore: (_streamsListFetch$val4 = streamsListFetch.value) === null || _streamsListFetch$val4 === void 0 ? void 0 : _streamsListFetch$val4.canReadFailureStore,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }), (groupStreams === null || groupStreams === void 0 ? void 0 : groupStreams.enabled) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_group_streams_cards.GroupStreamsCards, {
    streams: (_streamsListFetch$val5 = streamsListFetch.value) === null || _streamsListFetch$val5 === void 0 ? void 0 : _streamsListFetch$val5.streams,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 17
    }
  })))), isSettingsFlyoutOpen && /*#__PURE__*/_react.default.createElement(_streams_settings_flyout.StreamsSettingsFlyout, {
    onClose: () => setIsSettingsFlyoutOpen(false),
    refreshStreams: streamsListFetch.refresh,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }));
}
function WelcomePanel() {
  const {
    core: {
      docLinks
    }
  } = (0, _use_kibana.useKibana)();
  const [isDismissed, setIsDismissed] = (0, _useLocalStorage.default)('streamsWelcomePanelDismissed', false);
  if (isDismissed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "m",
    color: "subdued",
    grow: false,
    borderRadius: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
    type: "yourPreviewWillAppearHere",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.streams.streamsListView.welcomeTitle', {
    defaultMessage: 'Welcome to Streams'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.streams.streamsListView.welcomeDescription', {
    defaultMessage: 'Use Streams to organize and process your data into clear structured flows, and simplify routing, field extraction, and retention management.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    size: "s",
    href: docLinks.links.observability.logsStreams,
    target: "_blank",
    rel: "noopener",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.streams.streamsListView.learnMoreButtonLabel', {
    defaultMessage: 'Go to docs'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    size: "s",
    onClick: () => setIsDismissed(true),
    "aria-label": _i18n.i18n.translate('xpack.streams.streamsListView.dismissWelcomeButtonLabel', {
      defaultMessage: 'Dismiss welcome panel'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.streams.streamsListView.learnMoreButtonLabel', {
    defaultMessage: 'Hide this'
  }))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }));
}