"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentsColumn = DocumentsColumn;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _i18n = require("@kbn/i18n");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _esql_result_to_timeseries = require("../../util/esql_result_to_timeseries");
var _tooltip_popover_icon = require("../tooltip_popover_icon/tooltip_popover_icon");
var _errors = require("../../util/errors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_list_view/documents_column.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DocumentsColumn({
  indexPattern,
  histogramQueryFetch,
  timeState,
  numDataPoints
}) {
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const histogramQueryResult = (0, _useAsync.default)(() => histogramQueryFetch.docCount, [histogramQueryFetch]);
  const allTimeseries = _react.default.useMemo(() => (0, _esql_result_to_timeseries.esqlResultToTimeseries)({
    result: histogramQueryResult,
    metricNames: ['doc_count']
  }), [histogramQueryResult]);
  const docCount = _react.default.useMemo(() => allTimeseries.reduce((acc, series) => acc + series.data.reduce((acc2, item) => acc2 + (item.doc_count || 0), 0), 0), [allTimeseries]);
  const hasData = docCount > 0;
  const xFormatter = (0, _charts.niceTimeFormatter)([timeState.start, timeState.end]);
  const minInterval = Math.floor((timeState.end - timeState.start) / numDataPoints);
  const noDocCountData = histogramQueryResult.error ? '' : '-';
  const noHistogramData = histogramQueryResult.error ? /*#__PURE__*/_react.default.createElement(_tooltip_popover_icon.TooltipOrPopoverIcon, {
    dataTestSubj: "streamsDocCount-error",
    icon: "warning",
    title: (0, _errors.getFormattedError)(histogramQueryResult.error).message,
    mode: "popover",
    iconColor: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "visLine",
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  });
  const cellAriaLabel = hasData ? _i18n.i18n.translate('xpack.streams.documentsColumn.cellDocCountLabel', {
    defaultMessage: '{docCount} documents in {indexPattern}',
    values: {
      docCount,
      indexPattern
    }
  }) : _i18n.i18n.translate('xpack.streams.documentsColumn.cellNoDataLabel', {
    defaultMessage: 'No documents found in {indexPattern}',
    values: {
      indexPattern
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    className: (0, _css.css)`
        height: ${euiTheme.size.xl};
        white-space: nowrap;
      `,
    role: "group",
    "aria-label": cellAriaLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, histogramQueryResult.loading ? /*#__PURE__*/_react.default.createElement(LoadingPlaceholder, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    "aria-hidden": "true",
    className: (0, _css.css)`
              text-align: right;
              font-family: 'Roboto mono', sans-serif;
            `,
    "data-test-subj": `streamsDocCount-${indexPattern}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, hasData ? /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
    value: docCount,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 24
    }
  }) : noDocCountData), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    "aria-hidden": "true",
    className: (0, _css.css)`
              border-bottom: ${hasData ? '1px solid' : 'none'} ${euiTheme.colors.lightShade};
              display: flex;
              justify-content: center;
              align-items: center;
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, hasData ? /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      width: '100%',
      height: euiTheme.size.l
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    locale: _i18n.i18n.getLocale(),
    baseTheme: chartBaseTheme,
    theme: {
      background: {
        color: 'transparent'
      }
    },
    xDomain: {
      min: timeState.start,
      max: timeState.end,
      minInterval
    },
    noResults: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 30
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    stickTo: _charts.TooltipStickTo.Middle,
    headerFormatter: ({
      value
    }) => xFormatter(value),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 17
    }
  }), allTimeseries.map(serie => /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    key: serie.id,
    id: serie.id,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['doc_count'],
    data: serie.data,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 19
    }
  }))) : noHistogramData)));
}
const LoadingPlaceholder = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "m",
    className: (0, _css.css)`
        height: ${euiTheme.size.xl};
        white-space: nowrap;
        padding-right: ${euiTheme.size.xl};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _css.css)`
            text-align: center;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, "-"), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: (0, _css.css)`
            display: flex;
            padding-right: ${euiTheme.size.xl};
            justify-content: center;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }))));
};