"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SignificantEventsHistogramChart = SignificantEventsHistogramChart;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _spark_plot = require("../spark_plot");
var _get_annotation_from_formatted_change_point = require("./utils/get_annotation_from_formatted_change_point");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/significant_events_histogram.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SignificantEventsHistogramChart({
  id,
  occurrences,
  change,
  xFormatter
}) {
  const theme = (0, _eui.useEuiTheme)().euiTheme;
  const annotations = (0, _react.useMemo)(() => {
    if (!change) {
      return [];
    }
    return [(0, _get_annotation_from_formatted_change_point.getAnnotationFromFormattedChangePoint)({
      query: {
        id
      },
      change,
      theme,
      xFormatter
    })];
  }, [change, id, theme, xFormatter]);
  return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
    id: id,
    name: _i18n.i18n.translate('xpack.streams.significantEventsTable.histogramSeriesTitle', {
      defaultMessage: 'Count'
    }),
    timeseries: occurrences,
    type: "bar",
    annotations: annotations,
    xFormatter: xFormatter,
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
}