"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailReferencesView = StreamDetailReferencesView;
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_streams_app_fetch = require("../../hooks/use_streams_app_fetch");
var _use_kibana = require("../../hooks/use_kibana");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_references_view/stream_detail_references_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function StreamDetailReferencesView({
  definition
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const streamsListFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => {
    const {
      streams
    } = await streamsRepositoryClient.fetch('GET /internal/streams', {
      signal
    });
    return streams;
  }, [streamsRepositoryClient]);
  if (streamsListFetch.loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 12
      }
    });
  }
  if (!streamsListFetch.value) {
    return null;
  }
  const streams = streamsListFetch.value;
  const notMemberOfAnyGroupsMessage = _i18n.i18n.translate('xpack.streams.streamDetailReferencesView.notMemberOfAnyGroups', {
    defaultMessage: 'Not a member of any Group streams'
  });
  if (_streamsSchema.Streams.ingest.all.GetResponse.is(definition)) {
    const referencingGroups = streams.filter(stream => _streamsSchema.Streams.GroupStream.Definition.is(stream.stream)).filter(stream => stream.stream.group.members.includes(definition.stream.name));
    return referencingGroups.length === 0 ? notMemberOfAnyGroupsMessage : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.streams.streamDetailReferencesView.memberOfHeader', {
      defaultMessage: 'Member of:'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
      bordered: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }, referencingGroups.map(stream => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
      key: stream.stream.name,
      label: stream.stream.name,
      href: router.link('/{key}', {
        path: {
          key: stream.stream.name
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }))));
  }
  const referencingGroups = streams.filter(stream => _streamsSchema.Streams.GroupStream.Definition.is(stream.stream)).filter(stream => stream.stream.group.members.includes(definition.stream.name));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    alignItems: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, definition.stream.group.members.length === 0 ? _i18n.i18n.translate('xpack.streams.streamDetailReferencesView.noMembers', {
    defaultMessage: 'No members'
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.streams.streamDetailReferencesView.membersHeader', {
    defaultMessage: 'Members:'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    bordered: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  }, definition.stream.group.members.map(memberName => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: memberName,
    label: memberName,
    href: router.link('/{key}', {
      path: {
        key: memberName
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, referencingGroups.length === 0 ? notMemberOfAnyGroupsMessage : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.streams.streamDetailReferencesView.memberOfHeader', {
    defaultMessage: 'Member of:'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    bordered: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 15
    }
  }, referencingGroups.map(stream => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: stream.stream.name,
    label: stream.stream.name,
    href: router.link('/{key}', {
      path: {
        key: stream.stream.name
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 19
    }
  })))))));
}