"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditRoutingRuleControls = exports.AddRoutingRuleControls = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHooks = require("@kbn/react-hooks");
var _stream_delete_modal = require("../../stream_delete_modal");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/control_bars.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AddRoutingRuleControls = () => {
  const routingSnapshot = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot);
  const {
    cancelChanges,
    forkStream
  } = (0, _stream_routing_state_machine.useStreamRoutingEvents)();
  const isForking = routingSnapshot.matches({
    ready: {
      creatingNewRule: 'forking'
    }
  });
  const canForkRouting = routingSnapshot.can({
    type: 'routingRule.fork'
  });
  const hasPrivileges = routingSnapshot.context.definition.privileges.manage;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    wrap: true,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CancelButton, {
    isDisabled: isForking,
    onClick: cancelChanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(PrivilegesTooltip, {
    hasPrivileges: hasPrivileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SaveButton, {
    isLoading: isForking,
    isDisabled: !canForkRouting,
    onClick: () => forkStream(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  })));
};
exports.AddRoutingRuleControls = AddRoutingRuleControls;
const EditRoutingRuleControls = ({
  routingRule
}) => {
  const routingSnapshot = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot);
  const {
    cancelChanges,
    removeRule,
    saveChanges
  } = (0, _stream_routing_state_machine.useStreamRoutingEvents)();
  const routingRuleName = routingRule.destination;
  const isUpdating = routingSnapshot.matches({
    ready: {
      editingRule: 'updatingRule'
    }
  });
  const canUpdateRouting = routingSnapshot.can({
    type: 'routingRule.save'
  });
  const canRemoveRoutingRule = routingSnapshot.can({
    type: 'routingRule.remove'
  });
  const hasPrivileges = routingSnapshot.context.definition.privileges.manage;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(RemoveButton, {
    onDelete: removeRule,
    isDisabled: !canRemoveRoutingRule,
    streamName: routingRuleName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(CancelButton, {
    isDisabled: isUpdating,
    onClick: cancelChanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(PrivilegesTooltip, {
    hasPrivileges: hasPrivileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(UpdateButton, {
    isLoading: isUpdating,
    isDisabled: !canUpdateRouting,
    onClick: saveChanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  })))));
};
exports.EditRoutingRuleControls = EditRoutingRuleControls;
const RemoveButton = ({
  isDisabled,
  onDelete,
  streamName
}) => {
  const [isDeleteModalOpen, {
    on: openDeleteModal,
    off: closeDeleteModal
  }] = (0, _reactHooks.useBoolean)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    size: "s",
    "data-test-subj": "streamsAppRoutingStreamEntryRemoveButton",
    isDisabled: isDisabled,
    onClick: openDeleteModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.remove', {
    defaultMessage: 'Remove'
  })), isDeleteModalOpen && /*#__PURE__*/_react.default.createElement(_stream_delete_modal.StreamDeleteModal, {
    onClose: closeDeleteModal,
    onCancel: closeDeleteModal,
    onDelete: onDelete,
    name: streamName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }));
};
const SaveButton = props => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
  "data-test-subj": "streamsAppStreamDetailRoutingSaveButton",
  size: "s",
  fill: true
}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 119,
    columnNumber: 3
  }
}), _i18n.i18n.translate('xpack.streams.streamDetailRouting.add', {
  defaultMessage: 'Save'
}));
const UpdateButton = props => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
  "data-test-subj": "streamsAppStreamDetailRoutingUpdateButton",
  size: "s",
  fill: true
}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 127,
    columnNumber: 3
  }
}), _i18n.i18n.translate('xpack.streams.streamDetailRouting.change', {
  defaultMessage: 'Change routing'
}));
const CancelButton = props => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
  size: "s",
  "data-test-subj": "streamsAppRoutingStreamEntryCancelButton"
}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 135,
    columnNumber: 3
  }
}), _i18n.i18n.translate('xpack.streams.streamDetailRouting.cancel', {
  defaultMessage: 'Cancel'
}));
const PrivilegesTooltip = ({
  children,
  hasPrivileges
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: !hasPrivileges ? _i18n.i18n.translate('xpack.streams.streamDetailRouting.onlySimulate', {
    defaultMessage: "You don't have sufficient privileges to save changes."
  }) : undefined,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 149,
    columnNumber: 3
  }
}, children);