"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamFeatureConfiguration = StreamFeatureConfiguration;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_stream_features = require("./stream_features/hooks/use_stream_features");
var _use_ai_features = require("../../stream_detail_significant_events_view/add_significant_event_flyout/generated_flow_form/use_ai_features");
var _use_stream_features_api = require("../../../hooks/use_stream_features_api");
var _stream_features_flyout = require("./stream_features/stream_features_flyout");
var _stream_features_accordion = require("./stream_features/stream_features_accordion");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/stream_feature_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function StreamFeatureConfiguration({
  definition
}) {
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const {
    identifyFeatures,
    abort
  } = (0, _use_stream_features_api.useStreamFeaturesApi)(definition);
  const aiFeatures = (0, _use_ai_features.useAIFeatures)();
  const [features, setFeatures] = (0, _react.useState)([]);
  const {
    features: existingFeatures,
    refreshFeatures,
    featuresLoading
  } = (0, _use_stream_features.useStreamFeatures)(definition);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "none",
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.configurationTitle', {
    defaultMessage: 'Feature identification'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    css: {
      padding: '24px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      maxWidth: '40%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.configurationDescription', {
    defaultMessage: 'Use AI to generate logical subsets of the data in this stream. You will find useful insights like programming language, operating system, cloud provider etc. This is useful for generating better significant events.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !(aiFeatures !== null && aiFeatures !== void 0 && aiFeatures.genAiConnectors.selectedConnector),
    iconType: "sparkles",
    onClick: () => {
      setIsLoading(true);
      setIsFlyoutVisible(!isFlyoutVisible);
      identifyFeatures(aiFeatures === null || aiFeatures === void 0 ? void 0 : aiFeatures.genAiConnectors.selectedConnector, 'now', 'now-24h').then(data => {
        setFeatures(data.features);
      }).finally(() => {
        setIsLoading(false);
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.featureIdentificationButtonLabel', {
    defaultMessage: 'Identify features'
  })))), existingFeatures.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_stream_features_accordion.StreamFeaturesAccordion, {
    definition: definition,
    features: existingFeatures,
    loading: featuresLoading,
    refresh: refreshFeatures,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  })), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_stream_features_flyout.StreamFeaturesFlyout, {
    definition: definition,
    features: features,
    isLoading: isLoading,
    closeFlyout: () => {
      abort();
      refreshFeatures();
      setIsFlyoutVisible(false);
    },
    setFeatures: setFeatures,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  })));
}