"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupStreamDetailView = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/group_stream_detail_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GroupStreamDetailView = ({
  stream
}) => {
  const meta = [{
    title: _i18n.i18n.translate('xpack.streams.groupStreamDetailView.descriptionLabel', {
      defaultMessage: 'Description'
    }),
    description: stream.stream.description
  }, {
    title: _i18n.i18n.translate('xpack.streams.groupStreamDetailView.metadataLabel', {
      defaultMessage: 'Metadata'
    }),
    description: Object.keys(stream.stream.group.metadata).length === 0 ? _i18n.i18n.translate('xpack.streams.groupStreamDetailView.noMetadataLabel', {
      defaultMessage: 'None'
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 11
      }
    }, Object.entries(stream.stream.group.metadata).map(([key, value]) => `${key}: ${value}`).join('\n'))
  }, {
    title: _i18n.i18n.translate('xpack.streams.groupStreamDetailView.tagsLabel', {
      defaultMessage: 'Tags'
    }),
    description: stream.stream.group.tags.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      wrap: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 9
      }
    }, stream.stream.group.tags.map((tag, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 15
      }
    }, tag)))) : _i18n.i18n.translate('xpack.streams.groupStreamDetailView.noneLabel', {
      defaultMessage: 'None'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    listItems: meta,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 10
    }
  });
};
exports.GroupStreamDetailView = GroupStreamDetailView;