"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailLifecycle = StreamDetailLifecycle;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _failure_store = require("./failure_store");
var _general_data = require("./general_data");
var _use_data_stream_stats = require("./hooks/use_data_stream_stats");
var _use_timefilter = require("../../../hooks/use_timefilter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function StreamDetailLifecycle({
  definition,
  refreshDefinition
}) {
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const data = (0, _use_data_stream_stats.useDataStreamStats)({
    definition,
    timeState
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_general_data.StreamDetailGeneralData, {
    definition: definition,
    refreshDefinition: refreshDefinition,
    data: data,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_failure_store.StreamDetailFailureStore, {
    definition: definition,
    data: data,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }));
}