"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIlmPhasesColorAndDescription = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react = require("react");
var _rollover_condition = require("../helpers/rollover_condition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIlmPhasesColorAndDescription = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.useMemo)(() => ({
    ilmPhases: {
      hot: {
        color: euiTheme.colors.severity.risk,
        description: (phase, phases) => {
          const hotPhase = phase;
          const hasNextPhase = Boolean(phases.warm || phases.cold || phases.frozen || phases.delete);
          const condition = (0, _rollover_condition.rolloverCondition)(hotPhase.rollover);
          return (0, _lodash.compact)([_i18n.i18n.translate('xpack.streams.streamDetailLifecycle.hotPhaseDescription', {
            defaultMessage: 'Recent, frequently-searched data. Best indexing and search performance.'
          }), hasNextPhase ? condition ? _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.hotPhaseRolloverDescription', {
            defaultMessage: '*Time since rollover. Current rollover condition: {condition}.',
            values: {
              condition
            }
          }) : _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.hotPhaseNoRolloverDescription', {
            defaultMessage: '*Time since rollover. Data will not move to the next phase because rollover is not enabled.'
          }) : '']);
        }
      },
      warm: {
        color: euiTheme.colors.severity.warning,
        description: () => [_i18n.i18n.translate('xpack.streams.streamDetailLifecycle.warmPhaseDescription', {
          defaultMessage: 'Frequently searched data, rarely updated. Optimized for search, not indexing.'
        })]
      },
      cold: {
        color: euiTheme.colors.severity.neutral,
        description: () => [_i18n.i18n.translate('xpack.streams.streamDetailLifecycle.coldPhaseDescription', {
          defaultMessage: 'Data searched infrequently, not updated. Optimized for cost savings over search performance.'
        })]
      },
      frozen: {
        color: euiTheme.colors.vis.euiColorVis3,
        description: () => [_i18n.i18n.translate('xpack.streams.streamDetailLifecycle.frozenPhaseDescription', {
          defaultMessage: 'Most cost-effective way to store your data and still be able to search it.'
        })]
      },
      delete: {
        color: euiTheme.colors.borderBasePlain,
        description: phase => [_i18n.i18n.translate('xpack.streams.streamDetailLifecycle.deletePhaseDescription', {
          defaultMessage: 'Data deleted after {duration}.',
          values: {
            duration: phase.min_age
          }
        })]
      }
    }
  }), [euiTheme]);
};
exports.useIlmPhasesColorAndDescription = useIlmPhasesColorAndDescription;