"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeSizeAndUnitLabel = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timeUnitsLabels = {
  d: {
    plural: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.daysLabel', {
      defaultMessage: 'days'
    }),
    singular: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.dayLabel', {
      defaultMessage: 'day'
    })
  },
  h: {
    plural: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.hoursLabel', {
      defaultMessage: 'hours'
    }),
    singular: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.hourLabel', {
      defaultMessage: 'hour'
    })
  },
  m: {
    plural: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.minutesLabel', {
      defaultMessage: 'minutes'
    }),
    singular: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.minuteLabel', {
      defaultMessage: 'minute'
    })
  },
  s: {
    plural: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.secondsLabel', {
      defaultMessage: 'seconds'
    }),
    singular: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.secondLabel', {
      defaultMessage: 'second'
    })
  },
  ms: {
    plural: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.millisLabel', {
      defaultMessage: 'milliseconds'
    }),
    singular: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.milliLabel', {
      defaultMessage: 'millisecond'
    })
  },
  micros: {
    plural: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.microsLabel', {
      defaultMessage: 'microseconds'
    }),
    singular: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.microLabel', {
      defaultMessage: 'microsecond'
    })
  },
  nanos: {
    plural: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.nanosLabel', {
      defaultMessage: 'nanoseconds'
    }),
    singular: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.nanoLabel', {
      defaultMessage: 'nanosecond'
    })
  }
};
const splitSizeAndUnits = field => {
  let size = '';
  let unit = '';
  const result = /^(\d+)([a-zA-Z]+)$/.exec(field);
  if (result) {
    size = result[1];
    unit = result[2];
  }
  return {
    size,
    unit
  };
};
const getTimeSizeAndUnitLabel = value => {
  if (!value) return undefined;
  const {
    size,
    unit
  } = splitSizeAndUnits(value);
  const labels = timeUnitsLabels[unit];
  if (!labels) return value;
  return `${size} ${Number(size) === 1 ? labels.singular : labels.plural}`;
};
exports.getTimeSizeAndUnitLabel = getTimeSizeAndUnitLabel;