"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartBarPhasesSeries = ChartBarPhasesSeries;
exports.ChartBarSeries = ChartBarSeries;
exports.ChartBarSeriesBase = ChartBarSeriesBase;
exports.FailureStoreChartBarSeries = FailureStoreChartBarSeries;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _chartsTheme = require("@kbn/charts-theme");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _helpers = require("../helpers/helpers");
var _format_bytes = require("../helpers/format_bytes");
var _use_ilm_phases_color_and_description = require("../hooks/use_ilm_phases_color_and_description");
var _use_ingestion_rate = require("../hooks/use_ingestion_rate");
var _use_timefilter = require("../../../../hooks/use_timefilter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/common/chart_components.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ChartBarSeries({
  stats,
  timeState,
  isLoadingStats,
  aggregations,
  statsError
}) {
  const mainStreamResult = (0, _use_ingestion_rate.useIngestionRate)({
    calculatedStats: stats,
    timeState,
    aggregations,
    isLoading: isLoadingStats,
    error: statsError
  });
  const formatAsBytes = !!stats;
  const {
    ingestionRate,
    isLoading: isLoadingIngestionRate,
    error: ingestionRateError
  } = mainStreamResult;
  return /*#__PURE__*/_react.default.createElement(ChartBarSeriesBase, {
    ingestionRate: ingestionRate,
    isLoadingIngestionRate: isLoadingIngestionRate,
    ingestionRateError: ingestionRateError,
    isLoadingStats: isLoadingStats,
    formatAsBytes: formatAsBytes,
    isFailureStore: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  });
}
function FailureStoreChartBarSeries({
  stats,
  timeState,
  isLoadingStats,
  aggregations,
  statsError
}) {
  const failureStoreResult = (0, _use_ingestion_rate.useIngestionRate)({
    calculatedStats: stats,
    timeState,
    aggregations,
    isLoading: isLoadingStats,
    error: statsError
  });
  const formatAsBytes = !!stats;
  const {
    ingestionRate,
    isLoading: isLoadingIngestionRate,
    error: ingestionRateError
  } = failureStoreResult;
  return /*#__PURE__*/_react.default.createElement(ChartBarSeriesBase, {
    ingestionRate: ingestionRate,
    isLoadingIngestionRate: isLoadingIngestionRate,
    ingestionRateError: ingestionRateError,
    isLoadingStats: isLoadingStats,
    formatAsBytes: formatAsBytes,
    isFailureStore: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  });
}
function ChartBarSeriesBase({
  ingestionRate,
  isLoadingIngestionRate,
  ingestionRateError,
  isLoadingStats,
  formatAsBytes,
  isFailureStore
}) {
  // Use the appropriate hook based on isFailureStore flag
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return ingestionRateError ? 'Failed to load ingestion rate' : !ingestionRate && (isLoadingStats || isLoadingIngestionRate || !ingestionRate) ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 250
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    baseTheme: chartBaseTheme,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "ingestionRate",
    name: "Ingestion rate",
    data: ingestionRate.buckets,
    color: isFailureStore ? euiTheme.colors.severity.danger : euiTheme.colors.severity.success
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    xAccessor: 'key',
    yAccessors: ['value'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: value => (0, _moment.default)(value).format('YYYY-MM-DD HH:mm:ss'),
    gridLine: {
      visible: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    tickFormat: value => formatAsBytes ? (0, _format_bytes.formatBytes)(value) : (0, _eui.formatNumber)(value, '0,0'),
    gridLine: {
      visible: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  })));
}
function ChartBarPhasesSeriesBase({
  ingestionRate,
  isLoadingIngestionRate,
  ingestionRateError,
  isLoadingStats,
  formatAsBytes
}) {
  const {
    ilmPhases
  } = (0, _use_ilm_phases_color_and_description.useIlmPhasesColorAndDescription)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const availablePhases = (0, _react.useMemo)(() => {
    if (!ingestionRate) return {};
    const phaseKeys = Object.keys(ingestionRate.buckets);
    return phaseKeys.reduce((acc, phase) => {
      acc[phase] = {
        name: phase
      };
      return acc;
    }, {});
  }, [ingestionRate]);
  return ingestionRateError ? 'Failed to load ingestion rate' : !ingestionRate && (isLoadingStats || isLoadingIngestionRate || !ingestionRate) ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    css: {
      width: '100%'
    },
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 250
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    baseTheme: chartBaseTheme,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }), Object.entries(ingestionRate.buckets).map(([tier, buckets]) => /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: `ingestionRate-${tier}`,
    key: `ingestionRate-${tier}`,
    name: (0, _lodash.capitalize)(tier),
    data: buckets,
    color: ilmPhases[tier].color
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    xAccessor: 'key',
    yAccessors: ['value'],
    stackAccessors: [0],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: value => (0, _moment.default)(value).format('YYYY-MM-DD HH:mm:ss'),
    gridLine: {
      visible: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    tickFormat: value => formatAsBytes ? (0, _format_bytes.formatBytes)(value) : (0, _eui.formatNumber)(value, '0,0'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(PhasesLegend, {
    phases: availablePhases,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 11
    }
  }))));
}
function ChartBarPhasesSeries({
  definition,
  stats,
  timeState,
  isLoadingStats
}) {
  const {
    timeState: defaultTimeState
  } = (0, _use_timefilter.useTimefilter)();
  const currentTimeState = timeState || defaultTimeState;

  // Use the appropriate hook based on isFailureStore flag
  const mainStreamResult = (0, _use_ingestion_rate.useIngestionRatePerTier)({
    definition,
    calculatedStats: stats,
    timeState: currentTimeState
  });
  const {
    ingestionRate,
    isLoading: isLoadingIngestionRate,
    error: ingestionRateError
  } = mainStreamResult;
  const formatAsBytes = Boolean((stats === null || stats === void 0 ? void 0 : stats.bytesPerDoc) && (stats === null || stats === void 0 ? void 0 : stats.bytesPerDoc) > 0);
  return /*#__PURE__*/_react.default.createElement(ChartBarPhasesSeriesBase, {
    ingestionRate: ingestionRate,
    isLoadingIngestionRate: isLoadingIngestionRate,
    ingestionRateError: ingestionRateError,
    isLoadingStats: isLoadingStats,
    formatAsBytes: formatAsBytes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 5
    }
  });
}
function PhasesLegend({
  phases
}) {
  const {
    ilmPhases
  } = (0, _use_ilm_phases_color_and_description.useIlmPhasesColorAndDescription)();
  const availablePhases = (0, _react.useMemo)(() => {
    if (!phases) return [];
    const desc = (0, _helpers.orderIlmPhases)(phases).filter(({
      name
    }) => name !== 'delete').map(phase => ({
      name: phase.name,
      color: ilmPhases[phase.name].color
    }));
    return desc;
  }, [phases, ilmPhases]);
  if (!phases) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.dataTiers', {
    defaultMessage: 'Data Tiers'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 7
    }
  }), availablePhases.map(phase => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: phase.name,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      width: '20px',
      alignItems: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 13
    }
  }, 'color' in phase ? /*#__PURE__*/_react.default.createElement("span", {
    style: {
      height: '12px',
      width: '12px',
      borderRadius: '50%',
      backgroundColor: phase.color,
      display: 'inline-block'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: phase.icon,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 13
    }
  }, (0, _lodash.capitalize)(phase.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 11
    }
  }))));
}