"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _stream_enrichment_state_machine = require("../state_management/stream_enrichment_state_machine");
var _steps_list = require("./steps_list");
var _steps_state_machine = require("../state_management/steps_state_machine");
var _utils = require("../state_management/stream_enrichment_state_machine/utils");
var _use_steps_processing_summary = require("../state_management/use_steps_processing_summary");
var _create_step_button = require("../create_step_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/root_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RootSteps = ({
  stepRefs
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const rootSteps = stepRefs.filter(stepRef => (0, _steps_state_machine.isRootStep)(stepRef.getSnapshot()));
  const rootLevelMap = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => {
    const steps = state.context.stepRefs;
    return (0, _utils.getRootLevelStepsMap)(steps);
  });
  const stepsProcessingSummaryMap = (0, _use_steps_processing_summary.useStepsProcessingSummary)();
  const stepUnderEdit = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => {
    const underEdit = state.context.stepRefs.find(stepRef => (0, _steps_state_machine.isStepUnderEdit)(stepRef.getSnapshot()));
    return underEdit ? underEdit.getSnapshot().context.step : undefined;
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "streamsAppStreamDetailEnrichmentRootSteps",
    hasShadow: false,
    borderRadius: "none",
    css: (0, _react2.css)`
        overflow: auto;
        padding: ${euiTheme.size.xs};
        // Root panels
        > .euiPanel {
          margin-bottom: ${euiTheme.size.s};
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, rootSteps.map((stepRef, index) => /*#__PURE__*/_react.default.createElement(_steps_list.StepsListItem, {
    key: stepRef.id,
    stepRef: stepRef,
    level: 0,
    stepUnderEdit: stepUnderEdit,
    rootLevelMap: rootLevelMap,
    stepsProcessingSummaryMap: stepsProcessingSummaryMap,
    isFirstStepInLevel: index === 0,
    isLastStepInLevel: index === rootSteps.length - 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_create_step_button.CreateStepButton, {
    mode: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }))));
};
exports.RootSteps = RootSteps;