"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUrlInitializerActor = createUrlInitializerActor;
exports.createUrlSyncAction = createUrlSyncAction;
var _xstate = require("xstate5");
var _public = require("@kbn/kibana-utils-plugin/public");
var _url_schema = require("../../../../../../common/url_schema");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createUrlInitializerActor({
  core,
  urlStateStorageContainer
}) {
  return (0, _xstate.fromCallback)(({
    sendBack
  }) => {
    var _urlStateStorageConta;
    const urlStateValues = (_urlStateStorageConta = urlStateStorageContainer.get(_url_schema.ENRICHMENT_URL_STATE_KEY)) !== null && _urlStateStorageConta !== void 0 ? _urlStateStorageConta : undefined;
    if (!urlStateValues) {
      return sendBack({
        type: 'url.initialized',
        urlState: _utils.defaultEnrichmentUrlState
      });
    }
    const urlState = _url_schema.enrichmentUrlSchema.safeParse(urlStateValues);
    if (urlState.success) {
      // Always add default random samples data source
      if (!hasDefaultRandomSamplesDataSource(urlState.data.dataSources)) {
        urlState.data.dataSources.push(_utils.defaultRandomSamplesDataSource);
      }
      sendBack({
        type: 'url.initialized',
        urlState: urlState.data
      });
    } else {
      (0, _public.withNotifyOnErrors)(core.notifications.toasts).onGetError(new Error('The default state will be used as fallback.'));
      sendBack({
        type: 'url.initialized',
        urlState: _utils.defaultEnrichmentUrlState
      });
    }
  });
}
const hasDefaultRandomSamplesDataSource = dataSources => {
  return dataSources.some(dataSource => dataSource.type === 'random-samples');
};
function createUrlSyncAction({
  urlStateStorageContainer
}) {
  return ({
    context
  }) => {
    urlStateStorageContainer.set(_url_schema.ENRICHMENT_URL_STATE_KEY, context.urlState, {
      replace: true
    });
  };
}