"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootStreamEmptyPrompt = exports.NoStepsEmptyPrompt = exports.NoProcessingDataAvailableEmptyPrompt = exports.NoPreviewDocumentsEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _asset_image = require("../../asset_image");
var _create_step_button = require("./create_step_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/empty_prompts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RootStreamEmptyPrompt = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "aria-live": "polite",
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "processorsCannotBeAddedToRootStreams",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 19,
        columnNumber: 13
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.rootStreamEmptyPrompt.title', {
      defaultMessage: 'Processors cannot be added to root streams'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.rootStreamEmptyPrompt.body', {
      defaultMessage: 'To transform your data with processors, partition a new child stream.'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 16,
      columnNumber: 5
    }
  });
};
exports.RootStreamEmptyPrompt = RootStreamEmptyPrompt;
const NoStepsEmptyPrompt = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "aria-live": "polite",
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "extractFields",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.noStepsEmptyPrompt.title', {
      defaultMessage: 'Transform your data before indexing by:'
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.noStepsEmptyPrompt.body', {
      defaultMessage: 'Create conditions to focus on specific data in your stream.'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.noStepsEmptyPrompt.body', {
      defaultMessage: 'Create processors to extract meaningful fields so you can filter and analyze your data effectively.'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_create_step_button.CreateStepButton, {
      mode: "prominent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  });
};
exports.NoStepsEmptyPrompt = NoStepsEmptyPrompt;
const NoPreviewDocumentsEmptyPrompt = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "aria-live": "polite",
    icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "noResults",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }),
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noFilteredDocumentsTitle', {
      defaultMessage: 'No documents available'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noFilteredDocumentsBody', {
      defaultMessage: 'The current filter settings do not match any documents.'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  });
};
exports.NoPreviewDocumentsEmptyPrompt = NoPreviewDocumentsEmptyPrompt;
const NoProcessingDataAvailableEmptyPrompt = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "aria-live": "polite",
    color: "warning",
    iconType: "warning",
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noDataTitle', {
      defaultMessage: 'No data available to validate processor changes'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noDataBody', {
      defaultMessage: 'Changes will be applied, but we can’t confirm they’ll work as expected. Proceed with caution.'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  });
};
exports.NoProcessingDataAvailableEmptyPrompt = NoProcessingDataAvailableEmptyPrompt;