"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.docViewJson = exports.DOC_VIEW_JSON_ID = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _get_height = require("./get_height");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/doc_viewer_json.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DOC_VIEW_JSON_ID = exports.DOC_VIEW_JSON_ID = 'doc_view_json';
const docViewJson = exports.docViewJson = {
  id: DOC_VIEW_JSON_ID,
  title: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.docViews.json.jsonTitle', {
    defaultMessage: 'JSON'
  }),
  order: 20,
  component: JsonDocViewer
};
function JsonDocViewer({
  hit,
  decreaseAvailableHeightBy
}) {
  const wrapperRef = (0, _react.useRef)(null);
  const [editorHeight, setEditorHeight] = (0, _react.useState)(0);
  const jsonValue = (0, _react.useMemo)(() => JSON.stringify(hit.raw, null, 2), [hit.raw]);

  // compute height based on wrapper container
  (0, _react.useEffect)(() => {
    if (!wrapperRef.current) return;
    const height = (0, _get_height.getTabContentAvailableHeight)(wrapperRef.current, decreaseAvailableHeightBy !== null && decreaseAvailableHeightBy !== void 0 ? decreaseAvailableHeightBy : _get_height.DEFAULT_MARGIN_BOTTOM);
    setEditorHeight(height);
  }, [decreaseAvailableHeightBy, jsonValue]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: wrapperRef,
    style: {
      width: '100%',
      height: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.JsonCodeEditor, {
    json: hit.raw,
    width: "100%",
    height: editorHeight,
    hasLineNumbers: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
}