"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionEditor = ConditionEditor;
var _streamlang = require("@kbn/streamlang");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _react = _interopRequireWildcard(require("react"));
var _condition = require("../../../util/condition");
var _field_selector = require("./field_selector");
var _operator_selector = require("./operator_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/shared/condition_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ConditionEditor(props) {
  const {
    status,
    onConditionChange,
    fieldSuggestions = []
  } = props;
  const isInvalidCondition = !(0, _streamlang.isCondition)(props.condition);
  const condition = (0, _condition.alwaysToEmptyEquals)(props.condition);
  const conditionEditableInUi = (0, _react.useMemo)(() => (0, _condition.isConditionEditableInUi)(condition), [condition]);
  const [usingSyntaxEditor, toggleSyntaxEditor] = (0, _useToggle.default)(!conditionEditableInUi);
  const handleConditionChange = updatedCondition => {
    onConditionChange((0, _condition.emptyEqualsToAlways)(updatedCondition));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.conditionEditor.title', {
      defaultMessage: 'Condition'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      "data-test-subj": "streamsAppConditionEditorSwitch",
      label: _i18n.i18n.translate('xpack.streams.conditionEditor.switch', {
        defaultMessage: 'Syntax editor'
      }),
      compressed: true,
      checked: usingSyntaxEditor,
      onChange: toggleSyntaxEditor,
      disabled: status === 'disabled',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }),
    isInvalid: isInvalidCondition,
    error: isInvalidCondition ? _i18n.i18n.translate('xpack.streams.conditionEditor.error', {
      defaultMessage: 'The condition is invalid or in unrecognized format.'
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, usingSyntaxEditor ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    dataTestSubj: "streamsAppConditionEditorCodeEditor",
    height: 200,
    languageId: "json",
    value: JSON.stringify(condition, null, 2),
    onChange: value => {
      try {
        handleConditionChange(JSON.parse(value));
      } catch (error) {
        // do nothing
      }
    },
    options: {
      readOnly: status === 'disabled',
      automaticLayout: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }) : conditionEditableInUi ? /*#__PURE__*/_react.default.createElement(FilterConditionForm, {
    disabled: status === 'disabled',
    condition: condition,
    onConditionChange: handleConditionChange,
    fieldSuggestions: fieldSuggestions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    paddingSize: "m",
    isCopyable: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, JSON.stringify(condition, null, 2)));
}
function FilterConditionForm(props) {
  const {
    condition,
    disabled,
    onConditionChange,
    fieldSuggestions
  } = props;
  const operator = (0, _react.useMemo)(() => {
    return (0, _streamlang.getFilterOperator)(condition);
  }, [condition]);
  const value = (0, _react.useMemo)(() => {
    return (0, _streamlang.getFilterValue)(condition);
  }, [condition]);
  const handleConditionChange = updatedCondition => {
    onConditionChange({
      ...condition,
      ...updatedCondition
    });
  };
  const handleValueChange = nextValue => {
    onConditionChange({
      field: condition.field,
      [operator]: nextValue
    });
  };
  const showValueField = (0, _react.useMemo)(() => (0, _condition.conditionNeedsValueField)(condition), [condition]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    "data-test-subj": "streamsAppConditionEditor",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    value: condition.field,
    onChange: fieldValue => handleConditionChange({
      field: fieldValue
    }),
    placeholder: _i18n.i18n.translate('xpack.streams.filter.fieldPlaceholder', {
      defaultMessage: 'Field'
    }),
    suggestions: fieldSuggestions,
    compressed: true,
    disabled: disabled,
    dataTestSubj: "streamsAppConditionEditorFieldText",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: showValueField ? 1 : 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_operator_selector.OperatorSelector, {
    condition: condition,
    onConditionChange: onConditionChange,
    compressed: true,
    disabled: disabled,
    dataTestSubj: "streamsAppConditionEditorOperator",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }, showValueField ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, typeof value === 'string' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "aria-label": _i18n.i18n.translate('xpack.streams.filter.value', {
      defaultMessage: 'Value'
    }),
    placeholder: _i18n.i18n.translate('xpack.streams.filter.valuePlaceholder', {
      defaultMessage: 'Value'
    }),
    compressed: true,
    value: value,
    "data-test-subj": "streamsAppConditionEditorValueText",
    onChange: e => {
      handleValueChange(e.target.value);
    },
    disabled: disabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 15
    }
  }) : typeof value === 'boolean' ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.streams.conditionEditor.booleanLabel', {
      defaultMessage: 'Value'
    }),
    compressed: true,
    options: [{
      value: 'true',
      text: _i18n.i18n.translate('xpack.streams.conditionEditor.booleanValueTrue', {
        defaultMessage: 'True'
      })
    }, {
      value: 'false',
      text: _i18n.i18n.translate('xpack.streams.conditionEditor.booleanFalseValue', {
        defaultMessage: 'False'
      })
    }],
    value: String(value),
    "data-test-subj": "streamsAppFilterFormValueBoolean",
    onChange: e => {
      const nextValue = e.target.value === 'true';
      handleValueChange(nextValue);
    },
    disabled: disabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  }) : null) : null));
}