"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTypeSelector = exports.FieldNameSelector = exports.FieldFormatSelector = exports.AdvancedFieldMappingEditor = exports.AddFieldFlyout = exports.AddFieldButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _reactHookForm = require("react-hook-form");
var _codeEditor = require("@kbn/code-editor");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _otelSemanticConventions = require("@kbn/otel-semantic-conventions");
var _reactHooks = require("@kbn/react-hooks");
var _use_kibana = require("../../../../hooks/use_kibana");
var _schema_editor_context = require("../schema_editor_context");
var _field_form_type = require("./field_form_type");
var _field_form_format = require("./field_form_format");
var _helpers = require("../../stream_detail_enrichment/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/flyout/add_field_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddFieldButton = ({
  onAddField
}) => {
  const [isFlyoutVisible, {
    on: openFlyout,
    off: closeFlyout
  }] = (0, _reactHooks.useBoolean)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppContentAddFieldButton",
    iconType: "plus",
    onClick: openFlyout,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldButtonLabel', {
    defaultMessage: 'Add field'
  })), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(AddFieldFlyout, {
    onClose: closeFlyout,
    onAddField: onAddField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 27
    }
  }));
};
exports.AddFieldButton = AddFieldButton;
const AddFieldFlyout = ({
  onAddField,
  onClose
}) => {
  const {
    stream
  } = (0, _schema_editor_context.useSchemaEditorContext)();
  const flyoutId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'streams-add-field'
  });
  const methods = (0, _reactHookForm.useForm)({
    defaultValues: {
      status: 'mapped',
      name: '',
      type: undefined,
      parent: stream.name,
      additionalParameters: {}
    },
    mode: 'onChange'
  });
  const type = (0, _reactHookForm.useWatch)({
    control: methods.control,
    name: 'type'
  });
  const handleSubmit = data => {
    onAddField(data);
    onClose();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": flyoutId,
    maxWidth: 500,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.title', {
    defaultMessage: 'New field'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, methods, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    onSubmit: methods.handleSubmit(handleSubmit),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(FieldNameSelector, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(FieldTypeSelector, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }), (0, _field_form_format.typeSupportsFormat)(type) && /*#__PURE__*/_react.default.createElement(FieldFormatSelector, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 42
    }
  }), /*#__PURE__*/_react.default.createElement(AdvancedFieldMappingEditor, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppSchemaEditorAddFieldFlyoutCloseButton",
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.closeButtonLabel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppSchemaEditorAddFieldButton",
    onClick: methods.handleSubmit(handleSubmit),
    isDisabled: methods.formState.isSubmitted && !methods.formState.isValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.addButtonLabel', {
    defaultMessage: 'Add field'
  })))));
};
exports.AddFieldFlyout = AddFieldFlyout;
const FieldNameSelector = () => {
  var _fieldState$error;
  const {
    useFieldsMetadata
  } = (0, _use_kibana.useKibana)().dependencies.start.fieldsMetadata;
  const {
    fields,
    stream
  } = (0, _schema_editor_context.useSchemaEditorContext)();
  const {
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const {
    fieldsMetadata: rawFieldsMetadata
  } = useFieldsMetadata({
    attributes: ['ignore_above', 'type', 'otel_equivalent'],
    source: ['ecs', 'otel']
  });
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'name',
    rules: {
      required: _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.fieldNameRequiredError', {
        defaultMessage: 'A field name is required.'
      }),
      validate: name => {
        if (fields.some(f => f.name === name)) {
          return _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.fieldNameAlreadyExistsError', {
            defaultMessage: 'A field with this name already exists.'
          });
        }
        return true;
      }
    }
  });

  // Map the fields metadata to the OTel equivalent if the stream is a wired stream
  const fieldsMetadata = (0, _react.useMemo)(() => _streamsSchema.Streams.WiredStream.Definition.is(stream) ? (0, _lodash.mapKeys)(rawFieldsMetadata, (value, key) => {
    var _value$otel_equivalen;
    return (_value$otel_equivalen = value.otel_equivalent) !== null && _value$otel_equivalen !== void 0 ? _value$otel_equivalen : (0, _otelSemanticConventions.prefixOTelField)(key);
  }) : rawFieldsMetadata, [rawFieldsMetadata, stream]);
  const suggestions = (0, _react.useMemo)(() => {
    if (!fieldsMetadata) return [];
    const fieldNamesSet = new Set(fields.map(f => f.name));
    return Object.keys(fieldsMetadata).filter(name => !fieldNamesSet.has(name)).map(label => ({
      label
    }));
  }, [fieldsMetadata, fields]);
  const selectedOptions = (0, _react.useMemo)(() => {
    if (!field.value) return [];
    const matchingSuggestion = suggestions.find(suggestion => suggestion.label === field.value);
    return matchingSuggestion ? [matchingSuggestion] : [{
      label: field.value
    }];
  }, [field.value, suggestions]);
  const handleSelectionChange = newSelectedOptions => {
    var _selectedOption$label;
    const selectedOption = newSelectedOptions[0];
    const newFieldValue = (_selectedOption$label = selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.label) !== null && _selectedOption$label !== void 0 ? _selectedOption$label : '';
    field.onChange(newFieldValue);
    const fieldMetadata = fieldsMetadata === null || fieldsMetadata === void 0 ? void 0 : fieldsMetadata[newFieldValue];
    if (fieldMetadata !== null && fieldMetadata !== void 0 && fieldMetadata.type) {
      setValue('type', fieldMetadata.type);
    }
    if (fieldMetadata !== null && fieldMetadata !== void 0 && fieldMetadata.ignore_above) {
      setValue('additionalParameters', {
        ignore_above: fieldMetadata.ignore_above
      });
    } else {
      setValue('additionalParameters', {});
    }
  };
  const handleCreateOption = searchValue => {
    const normalizedValue = searchValue.trim();
    if (normalizedValue) {
      handleSelectionChange([{
        label: normalizedValue
      }]);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.fieldSelector.defaultLabel', {
      defaultMessage: 'Field name'
    }),
    helpText: _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.fieldTypeHelpText', {
      defaultMessage: 'We suggest naming conventions like ECS or OTel.'
    }),
    isInvalid: fieldState.invalid,
    error: (_fieldState$error = fieldState.error) === null || _fieldState$error === void 0 ? void 0 : _fieldState$error.message,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "streamsAppSchemaEditorAddFieldFlyoutFieldName",
    placeholder: _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.fieldNamePlaceholder', {
      defaultMessage: 'Select or type a field name...'
    }),
    options: suggestions,
    selectedOptions: selectedOptions,
    onChange: handleSelectionChange,
    onCreateOption: handleCreateOption,
    singleSelection: {
      asPlainText: true
    },
    isInvalid: fieldState.invalid,
    isClearable: true,
    fullWidth: true,
    customOptionText: _i18n.i18n.translate('xpack.streams.fieldSelector.customOptionText', {
      defaultMessage: 'Add {searchValue} as a custom field',
      values: {
        searchValue: '{searchValue}'
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }));
};
exports.FieldNameSelector = FieldNameSelector;
const FieldTypeSelector = () => {
  var _fieldState$error2;
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'type',
    rules: {
      required: _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.fieldNameRequiredError', {
        defaultMessage: 'A field type is required.'
      })
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.fieldTypeLabel', {
      defaultMessage: 'Field type'
    }),
    helpText: _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.fieldTypeHelpText', {
      defaultMessage: 'We prefill the field type when matching an ECS or OTel field name.'
    }),
    fullWidth: true,
    isInvalid: fieldState.invalid,
    error: (_fieldState$error2 = fieldState.error) === null || _fieldState$error2 === void 0 ? void 0 : _fieldState$error2.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_form_type.FieldTypeSelector, {
    value: field.value,
    onChange: field.onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 7
    }
  }));
};
exports.FieldTypeSelector = FieldTypeSelector;
const FieldFormatSelector = () => {
  const {
    field
  } = (0, _reactHookForm.useController)({
    name: 'format'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.fieldFormatSelector.label', {
      defaultMessage: 'Field format'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_form_format.FieldFormFormat, {
    onChange: field.onChange,
    value: field.value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 7
    }
  }));
};
exports.FieldFormatSelector = FieldFormatSelector;
const AdvancedFieldMappingEditor = () => {
  var _fieldState$error3;
  const {
    core
  } = (0, _use_kibana.useKibana)();
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'additionalParameters',
    rules: {
      validate: value => {
        const isValid = Boolean(!value || value === '' || (0, _streamsSchema.isSchema)(_streamsSchema.recursiveRecord, value));
        if (!isValid) {
          return _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.advancedFieldMappingOptions.error', {
            defaultMessage: 'Invalid advanced field mapping parameters. It should be defined as a JSON object.'
          });
        }
        return true;
      }
    }
  });

  /**
   * To have the editor properly handle the set xjson language
   * we need to avoid the continuous parsing/serialization of the editor value
   * using a parallel state always setting a string make the editor format well the content.
   */
  const serializedValue = (0, _react.useMemo)(() => (0, _helpers.serializeXJson)(field.value), [field.value]);
  const [value, setValue] = _react.default.useState(serializedValue);
  // Sync internal state for editor with the form value controlled by the form
  if (value !== serializedValue) {
    setValue(serializedValue);
  }
  const handleChange = newValue => {
    setValue(newValue);
    field.onChange((0, _helpers.deserializeJson)(newValue));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.schemaEditor.addFieldFlyout.advancedFieldMappingOptions.label', {
      defaultMessage: 'Advanced field mapping parameters'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.schemaEditor.addFieldFlyout.advancedFieldMappingOptions.docs.label",
      defaultMessage: "Parameters can be defined with JSON. {link}",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAdvancedFieldMappingOptionsViewDocumentationLink",
          href: core.docLinks.links.elasticsearch.mappingParameters,
          target: "_blank",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 347,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.streams.indexPattern.randomSampling.learnMore",
          defaultMessage: "View documentation.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 353,
            columnNumber: 17
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 342,
        columnNumber: 9
      }
    }),
    fullWidth: true,
    isInvalid: fieldState.invalid,
    error: (_fieldState$error3 = fieldState.error) === null || _fieldState$error3 === void 0 ? void 0 : _fieldState$error3.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 120,
    languageId: "xjson",
    value: value,
    onChange: handleChange,
    options: {
      automaticLayout: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 7
    }
  }));
};
exports.AdvancedFieldMappingEditor = AdvancedFieldMappingEditor;