"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.containsAssets = containsAssets;
exports.containsMappings = containsMappings;
exports.hasSelectedObjects = hasSelectedObjects;
exports.isEmptyContentPack = isEmptyContentPack;
var _lodash = require("lodash");
var _contentPacksSchema = require("@kbn/content-packs-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function hasSelectedObjects(includedObjects) {
  return (0, _contentPacksSchema.isIncludeAll)(includedObjects) || includedObjects.objects.queries.length > 0 || includedObjects.objects.routing.length > 0 || includedObjects.objects.mappings;
}
function containsAssets(streams) {
  return streams.some(stream => stream.request.queries.length > 0);
}
function containsMappings(streams) {
  return streams.some(stream => !(0, _lodash.isEmpty)(stream.request.stream.ingest.wired.fields));
}
function isEmptyContentPack(entries) {
  if (entries.length === 0) {
    return true;
  }
  const streams = entries.filter(entry => entry.type === 'stream');
  if (entries.length === streams.length && streams.length === 1) {
    // only root stream included
    return streams[0].request.queries.length === 0 && (0, _lodash.isEmpty)(streams[0].request.stream.ingest.wired.fields);
  }
  return false;
}