"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerateSignificantEventsPrompt = void 0;
var _zod = require("@kbn/zod");
var _inferenceCommon = require("@kbn/inference-common");
var _system_prompt = _interopRequireDefault(require("./system_prompt.text"));
var _user_prompt = _interopRequireDefault(require("./user_prompt.text"));
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenerateSignificantEventsPrompt = exports.GenerateSignificantEventsPrompt = (0, _inferenceCommon.createPrompt)({
  name: 'generate_significant_events',
  input: _zod.z.object({
    name: _zod.z.string(),
    description: _zod.z.string(),
    dataset_analysis: _zod.z.string()
  })
}).version({
  system: {
    mustache: {
      template: _system_prompt.default
    }
  },
  template: {
    mustache: {
      template: _user_prompt.default
    }
  },
  tools: {
    add_queries: {
      description: `Add queries to suggest to the user`,
      schema: {
        type: 'object',
        properties: {
          queries: {
            type: 'array',
            items: {
              type: 'object',
              properties: {
                kql: {
                  type: 'string'
                },
                title: {
                  type: 'string'
                },
                category: {
                  type: 'string',
                  enum: [_types.SIGNIFICANT_EVENT_TYPE_OPERATIONAL, _types.SIGNIFICANT_EVENT_TYPE_CONFIGURATION, _types.SIGNIFICANT_EVENT_TYPE_ERROR, _types.SIGNIFICANT_EVENT_TYPE_RESOURCE_HEALTH, _types.SIGNIFICANT_EVENT_TYPE_SECURITY]
                }
              },
              required: ['kql', 'title', 'category']
            }
          }
        },
        required: ['queries']
      }
    }
  }
}).get();