"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transpile = void 0;
var _function = require("fp-ts/function");
var _streamlang = require("../../../types/streamlang");
var _flatten_steps = require("../shared/flatten_steps");
var _conversions = require("./conversions");
var _post_processing = require("./processors/post_processing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transpile = (streamlang, transpilationOptions) => {
  const validatedStreamlang = _streamlang.streamlangDSLSchema.parse(streamlang);
  const processors = (0, _function.pipe)((0, _flatten_steps.flattenSteps)(validatedStreamlang.steps), steps => (0, _conversions.convertStreamlangDSLActionsToIngestPipelineProcessors)(steps, transpilationOptions), _post_processing.applyPostProcessing);
  return {
    processors
  };
};
exports.transpile = transpile;